/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.ArrayList;
import org.drools.eclipse.editors.completion.CompletionUtil;
import org.drools.eclipse.editors.completion.DefaultCompletionProcessor;
import org.drools.eclipse.editors.completion.RuleCompletionProposal;
import org.junit.Assert;
import org.junit.Test;

public class DRLCompletionProcessorTest {
    @Test
    public void testLookBehind() {
        Assert.assertEquals((Object)"something", (Object)CompletionUtil.stripLastWord((String)" something"));
        Assert.assertEquals((Object)"another", (Object)CompletionUtil.stripLastWord((String)"another"));
        String s = "rule something \n\nwhen";
        Assert.assertEquals((Object)"when", (Object)CompletionUtil.stripLastWord((String)s));
    }

    @Test
    public void testPrefixFiltering_FiltersBasedOnDisplayedStringNotContent() {
        ArrayList<RuleCompletionProposal> list = new ArrayList<RuleCompletionProposal>();
        list.add(new RuleCompletionProposal(0, 0, "abcd", "zxyz"));
        list.add(new RuleCompletionProposal(0, 0, "azard", "good"));
        list.add(new RuleCompletionProposal(0, 0, "art", "apple"));
        list.add(new RuleCompletionProposal(0, 0, "spe", "ape"));
        DefaultCompletionProcessor.filterProposalsOnPrefix((String)"a", list);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"zxyz", (Object)list.get(0).toString());
        Assert.assertEquals((Object)"good", (Object)list.get(1).toString());
        Assert.assertEquals((Object)"apple", (Object)list.get(2).toString());
    }

    @Test
    public void testPrefixFiltering_FiltersAllWhenThereisNoMatches() {
        ArrayList<RuleCompletionProposal> list = new ArrayList<RuleCompletionProposal>();
        list = new ArrayList();
        list.add(new RuleCompletionProposal(0, 0, "aardvark", "something"));
        list.add(new RuleCompletionProposal(0, 0, "smeg"));
        list.add(new RuleCompletionProposal(0, 0, "apple"));
        list.add(new RuleCompletionProposal(0, 0, "ape", "zzzzz"));
        DefaultCompletionProcessor.filterProposalsOnPrefix((String)"xzyz", list);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testPrefixFiltering_IgnoreCase() {
        ArrayList<RuleCompletionProposal> list = new ArrayList<RuleCompletionProposal>();
        list = new ArrayList();
        list.add(new RuleCompletionProposal(0, 0, "ART"));
        list.add(new RuleCompletionProposal(0, 0, "art"));
        list.add(new RuleCompletionProposal(0, 0, "aRT"));
        list.add(new RuleCompletionProposal(0, 0, "Art", "zzzzz"));
        DefaultCompletionProcessor.filterProposalsOnPrefix((String)"art", list);
        Assert.assertEquals((long)4L, (long)list.size());
        DefaultCompletionProcessor.filterProposalsOnPrefix((String)"ART", list);
        Assert.assertEquals((long)4L, (long)list.size());
    }
}

