/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.ArrayList;
import org.drools.eclipse.editors.completion.CompletionUtil;
import org.drools.eclipse.editors.completion.RuleCompletionProcessor;
import org.drools.mvel.asm.KnowledgeHelperFixer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RuleCompletionProcessorTest {
    @Ignore
    @Test
    public void testContainsProposal() {
        ArrayList<MockCompletionProposal> proposals = new ArrayList<MockCompletionProposal>();
        MockCompletionProposal c1 = new MockCompletionProposal("getName() Object - MyObject");
        proposals.add(c1);
        String newProposal = "getName() String - CompletionProposal";
        Assert.assertTrue((boolean)RuleCompletionProcessor.containsProposal(proposals, (String)newProposal));
        MockCompletionProposal c2 = new MockCompletionProposal("getNoName() Object - MyObject");
        proposals.add(c2);
        Assert.assertFalse((boolean)RuleCompletionProcessor.containsProposal(proposals, (String)"getNoName"));
    }

    @Ignore
    @Test
    public void testAddAllNewProposals() {
        ArrayList<MockCompletionProposal> proposals = new ArrayList<MockCompletionProposal>();
        MockCompletionProposal c = new MockCompletionProposal("getName() Object - MyObject");
        proposals.add(c);
        ArrayList<MockCompletionProposal> newProposals = new ArrayList<MockCompletionProposal>();
        MockCompletionProposal c1 = new MockCompletionProposal("getName() Objectw - MyObject");
        newProposals.add(c1);
        MockCompletionProposal c2 = new MockCompletionProposal("getNoName() Object - MyObject");
        newProposals.add(c2);
        MockCompletionProposal c3 = new MockCompletionProposal("getNoName() NoObject - MyObject");
        newProposals.add(c3);
        RuleCompletionProcessor.addAllNewProposals(proposals, newProposals);
        Assert.assertTrue((proposals.size() == 2 ? 1 : 0) != 0);
        ICompletionProposal prop = (ICompletionProposal)proposals.get(1);
        Assert.assertEquals((Object)"getNoName() Object - MyObject", (Object)prop.getDisplayString());
    }

    @Test
    public void testProcessMacros() {
        String[] functions = new String[]{"update", "retract", "insert", "insertLogical"};
        int i = 0;
        while (i < functions.length) {
            String string = functions[i];
            String expected = "drools." + string;
            new KnowledgeHelperFixer();
            Assert.assertEquals((Object)expected, (Object)KnowledgeHelperFixer.fix((String)string));
            ++i;
        }
    }

    @Test
    public void testIsStartOfDialectExpression() {
        String s = "System.out.println(\"\");\r\n  update(";
        Assert.assertFalse((boolean)CompletionUtil.isStartOfDialectExpression((String)s));
    }

    class MockCompletionProposal
    implements ICompletionProposal {
        String displayString;

        public MockCompletionProposal(String displayString) {
            this.displayString = displayString;
        }

        public void apply(IDocument document) {
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return this.displayString;
        }

        public Image getImage() {
            return null;
        }

        public Point getSelection(IDocument document) {
            return null;
        }
    }
}

