/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import org.drools.lang.dsl.DSLMappingEntry;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MappingEditor
extends TitleAreaDialog {
    private static final int SCOPE_KEYWORD = 0;
    private static final int SCOPE_WHEN = 1;
    private static final int SCOPE_THEN = 2;
    private static final int SCOPE_ALL = 3;
    private static final String SCOPE_STR_KEYWORD = "keyword";
    private static final String SCOPE_STR_WHEN = "condition";
    private static final String SCOPE_STR_THEN = "consequence";
    private static final String SCOPE_STR_ALL = "*";
    private Text exprText;
    private Text mappingText;
    private Text objText;
    private Combo scopeCombo;
    private boolean cancelled;
    private DSLMappingEntry model;

    protected MappingEditor(Shell parent) {
        super(parent);
    }

    public void setNLMappingItem(DSLMappingEntry item) {
        this.model = item;
        this.setSection(this.model.getSection());
        this.exprText.setText(this.model.getMappingKey() == null ? "" : this.model.getMappingKey());
        this.mappingText.setText(this.model.getMappingValue() == null ? "" : this.model.getMappingValue());
        this.objText.setText(this.model.getMetaData().getMetaData() == null ? "" : this.model.getMetaData().getMetaData());
    }

    private void setSection(DSLMappingEntry.Section section) {
        if (section == DSLMappingEntry.CONDITION) {
            this.scopeCombo.select(1);
        } else if (section == DSLMappingEntry.CONSEQUENCE) {
            this.scopeCombo.select(2);
        } else if (section == DSLMappingEntry.ANY) {
            this.scopeCombo.select(3);
        } else if (section == DSLMappingEntry.KEYWORD) {
            this.scopeCombo.select(0);
        } else {
            throw new IllegalArgumentException("Unknown scope type: " + section);
        }
    }

    private DSLMappingEntry.Section getSection(String sectionStr) {
        DSLMappingEntry.Section section = DSLMappingEntry.ANY;
        if (SCOPE_STR_KEYWORD.equals(sectionStr)) {
            section = DSLMappingEntry.KEYWORD;
        } else if (SCOPE_STR_WHEN.equals(sectionStr)) {
            section = DSLMappingEntry.CONDITION;
        } else if (SCOPE_STR_THEN.equals(sectionStr)) {
            section = DSLMappingEntry.CONSEQUENCE;
        }
        return section;
    }

    protected void cancelPressed() {
        this.cancelled = true;
        super.cancelPressed();
    }

    protected void okPressed() {
        this.cancelled = false;
        this.model.setMappingKey(this.exprText.getText());
        this.model.setMappingValue(this.mappingText.getText());
        this.model.setSection(this.getSection(this.scopeCombo.getText()));
        this.model.setMetaData((DSLMappingEntry.MetaData)new DSLMappingEntry.DefaultDSLEntryMetaData(this.objText.getText()));
        super.okPressed();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 10;
        gridLayout.numColumns = 2;
        parent.setLayout((Layout)gridLayout);
        this.createExpressionField(parent);
        this.createMappingField(parent);
        this.createObjectField(parent);
        this.createScopeField(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    private void createMappingField(Composite parent) {
        Label mappingLbl = new Label(parent, 0);
        mappingLbl.setText("Rule mapping:");
        mappingLbl.setFont(parent.getFont());
        mappingLbl.setLayoutData((Object)new GridData(128));
        this.mappingText = new Text(parent, 2048);
        GridData data = new GridData();
        data.widthHint = 450;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.mappingText.setLayoutData((Object)data);
        this.mappingText.setToolTipText("Enter the rule language mapping that the \nlanguage item will be translated to. Use the named variables (holes) \nthat you specify in the language expression above.");
    }

    private void createExpressionField(Composite parent) {
        Label exprLbl = new Label(parent, 0);
        exprLbl.setText("Language expression:");
        exprLbl.setFont(parent.getFont());
        exprLbl.setLayoutData((Object)new GridData(128));
        this.exprText = new Text(parent, 2048);
        GridData data = new GridData();
        data.widthHint = 450;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.exprText.setLayoutData((Object)data);
        this.exprText.setToolTipText("Enter the language expression that you want to use in a rule.\nUse curly brackets to mark 'holes' where the values will be extracted\nfrom in the rule source. Such as: Person has a name of {name} \nThis will then parse the rule source to extract the data out of \nthe place where {name} would appear.");
    }

    private void createObjectField(Composite parent) {
        Label objectLbl = new Label(parent, 0);
        objectLbl.setText("Object:");
        objectLbl.setFont(parent.getFont());
        objectLbl.setLayoutData((Object)new GridData(128));
        this.objText = new Text(parent, 2048);
        GridData data = new GridData();
        data.widthHint = 450;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.objText.setLayoutData((Object)data);
        this.objText.setToolTipText("Enter the name of the object.");
    }

    private void createScopeField(Composite parent) {
        Label scopeLbl = new Label(parent, 0);
        scopeLbl.setText("Scope:");
        scopeLbl.setFont(parent.getFont());
        scopeLbl.setLayoutData((Object)new GridData(128));
        this.scopeCombo = new Combo(parent, 8);
        this.scopeCombo.add(SCOPE_STR_KEYWORD, 0);
        this.scopeCombo.add(SCOPE_STR_WHEN, 1);
        this.scopeCombo.add(SCOPE_STR_THEN, 2);
        this.scopeCombo.add(SCOPE_STR_ALL, 3);
        this.scopeCombo.select(3);
        this.scopeCombo.setLayoutData((Object)new GridData(32));
        this.scopeCombo.setFont(parent.getFont());
        this.scopeCombo.setToolTipText("This specifies what part of the rule the expression applies. Indicating '*' means global.");
    }
}

