/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private HashMap<String, Node> children = new HashMap();
    private Node parent = null;
    private String token;
    private int depth = 0;

    public Node(String name) {
        this.token = name;
    }

    public Node addToken(String token) {
        Node newnode = new Node(token);
        newnode.setDepth(this.depth + 1);
        newnode = this.addChild(newnode);
        return newnode;
    }

    public boolean isMatch(String input) {
        return input.equals(this.token);
    }

    public boolean isMatch(Node n) {
        return this.token.equals(n.getToken());
    }

    public Node addChild(Node n) {
        if (!this.children.containsKey(n.getToken())) {
            this.children.put(n.getToken(), n);
            n.setParent(this);
            return n;
        }
        return this.children.get(n.getToken());
    }

    public void removeChild(Node n) {
        this.children.remove(n.getToken());
    }

    public Collection<Node> getChildren() {
        return this.children.values();
    }

    public Node getChild(String token) {
        return this.children.get(token);
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void clearChildren() {
        this.children.clear();
    }
}

