/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.outline;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.DroolsParserException;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.core.DroolsElement;
import org.drools.eclipse.core.DroolsModelBuilder;
import org.drools.eclipse.core.Package;
import org.drools.eclipse.core.RuleSet;
import org.drools.eclipse.core.ui.DroolsContentProvider;
import org.drools.eclipse.core.ui.DroolsGroupByRuleGroupContentProvider;
import org.drools.eclipse.core.ui.DroolsLabelProvider;
import org.drools.eclipse.core.ui.DroolsTreeSorter;
import org.drools.eclipse.core.ui.FilterActionGroup;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleContentOutlinePage
extends ContentOutlinePage {
    private AbstractRuleEditor editor;
    private RuleSet ruleSet = DroolsModelBuilder.createRuleSet();
    private Map<String, RuleDescr> rules;
    private boolean groupByRulegroup = false;
    private TreeViewer viewer = null;
    private static final Pattern RULE_PATTERN1 = Pattern.compile("\\n\\s*rule\\s+\"([^\"]+)\"", 32);
    private static final Pattern RULE_PATTERN2 = Pattern.compile("\\n\\s*rule\\s+([^\\s;#\"]+)", 32);
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("\\s*package\\s+([^\\s;#]+);?", 32);
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("\\n\\s*function\\s+(\\S+)\\s+(\\S+)\\(.*?\\)", 32);
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\n\\s*template\\s+([^\\s;#\"]+)", 32);
    private static final Pattern IMPORT_PATTERN = Pattern.compile("\\n\\s*import\\s+([^\\s;#]+);?", 32);
    private static final Pattern EXPANDER_PATTERN = Pattern.compile("\\n\\s*expander\\s+([^\\s;#]+);?", 32);
    private static final Pattern GLOBAL_PATTERN = Pattern.compile("\\n\\s*global\\s+(\\S+)\\s+([^\\s;#]+);?", 32);
    private static final Pattern QUERY_PATTERN1 = Pattern.compile("\\n\\s*query\\s+\"([^\"]+)\"", 32);
    private static final Pattern QUERY_PATTERN2 = Pattern.compile("\\n\\s*query\\s+([^\\s;#\"]+)", 32);
    DroolsContentProvider contentProvider = null;
    DroolsGroupByRuleGroupContentProvider groupByRuleGroupContentProvider = null;

    public RuleContentOutlinePage(AbstractRuleEditor editor) {
        this.editor = editor;
    }

    private void setContentProvider() {
        IPreferenceStore preferenceStore = DroolsEclipsePlugin.getDefault().getPreferenceStore();
        this.groupByRulegroup = preferenceStore.getBoolean("GroupByRuleGroupAction.isChecked");
        this.contentProvider = new DroolsContentProvider();
        this.groupByRuleGroupContentProvider = new DroolsGroupByRuleGroupContentProvider();
        if (this.groupByRulegroup) {
            this.viewer.setContentProvider((IContentProvider)this.groupByRuleGroupContentProvider);
        } else {
            this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.setContentProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DroolsLabelProvider());
        this.viewer.setSorter((ViewerSorter)new DroolsTreeSorter());
        this.viewer.setInput((Object)this.ruleSet);
        FilterActionGroup filterActionGroup = new FilterActionGroup((StructuredViewer)this.viewer, "org.drools.eclipse.editors.outline.RuleContentOutlinePage");
        filterActionGroup.fillActionBars(this.getSite().getActionBars());
        this.update();
        super.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel;
                DroolsElement element;
                ISelection selectionObj = event.getSelection();
                if (selectionObj != null && selectionObj instanceof StructuredSelection && (element = (DroolsElement)(sel = (StructuredSelection)selectionObj).getFirstElement()) != null) {
                    RuleContentOutlinePage.this.editor.selectAndReveal(element.getOffset(), element.getLength());
                }
            }
        });
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            this.initRules();
            this.populatePackageTreeNode();
            viewer.refresh();
            control.setRedraw(false);
            viewer.expandToLevel(2);
            control.setRedraw(true);
        }
    }

    public void populatePackageTreeNode() {
        String ruleFileContents = this.editor.getContent();
        this.populatePackageTreeNode(ruleFileContents);
    }

    void populatePackageTreeNode(String ruleFileContents) {
        String queryName;
        RuleDescr descr;
        String ruleName;
        DroolsModelBuilder.clearRuleSet(this.ruleSet);
        Matcher matcher = PACKAGE_PATTERN.matcher(ruleFileContents);
        String packageName = null;
        int startChar = 0;
        int endChar = 0;
        if (matcher.find()) {
            packageName = matcher.group(1);
            startChar = matcher.start(1);
            endChar = matcher.end(1);
        }
        Package pkg = DroolsModelBuilder.addPackage(this.ruleSet, packageName, startChar, endChar - startChar);
        matcher = RULE_PATTERN1.matcher(ruleFileContents);
        while (matcher.find()) {
            ruleName = matcher.group(1);
            descr = this.rules.get(ruleName);
            if (descr == null) continue;
            DroolsModelBuilder.addRule(pkg, ruleName, null, matcher.start(1), matcher.end(1) - matcher.start(1), this.extractAttributes(descr));
        }
        matcher = RULE_PATTERN2.matcher(ruleFileContents);
        while (matcher.find()) {
            ruleName = matcher.group(1);
            descr = this.rules.get(ruleName);
            if (descr == null) continue;
            DroolsModelBuilder.addRule(pkg, ruleName, null, matcher.start(1), matcher.end(1) - matcher.start(1), this.extractAttributes(descr));
        }
        matcher = FUNCTION_PATTERN.matcher(ruleFileContents);
        while (matcher.find()) {
            String functionName = matcher.group(2);
            DroolsModelBuilder.addFunction(pkg, String.valueOf(functionName) + "()", null, matcher.start(2), matcher.end(2) - matcher.start(2));
        }
        matcher = EXPANDER_PATTERN.matcher(ruleFileContents);
        if (matcher.find()) {
            String expanderName = matcher.group(1);
            DroolsModelBuilder.addExpander(pkg, expanderName, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        matcher = IMPORT_PATTERN.matcher(ruleFileContents);
        while (matcher.find()) {
            String importName = matcher.group(1);
            DroolsModelBuilder.addImport(pkg, importName, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        matcher = GLOBAL_PATTERN.matcher(ruleFileContents);
        while (matcher.find()) {
            String globalType = matcher.group(1);
            String globalName = matcher.group(2);
            String name = String.valueOf(globalName) + " : " + globalType;
            DroolsModelBuilder.addGlobal(pkg, name, null, matcher.start(2), matcher.end(2) - matcher.start(2));
        }
        matcher = QUERY_PATTERN1.matcher(ruleFileContents);
        while (matcher.find()) {
            queryName = matcher.group(1);
            DroolsModelBuilder.addQuery(pkg, queryName, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        matcher = QUERY_PATTERN2.matcher(ruleFileContents);
        while (matcher.find()) {
            queryName = matcher.group(1);
            DroolsModelBuilder.addQuery(pkg, queryName, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        matcher = TEMPLATE_PATTERN.matcher(ruleFileContents);
        while (matcher.find()) {
            String templateName = matcher.group(1);
            DroolsModelBuilder.addTemplate(pkg, templateName, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
    }

    RuleSet getRuleSet() {
        return this.ruleSet;
    }

    private Map<String, String> extractAttributes(RuleDescr ruleDescr) {
        HashMap<String, String> attributes = null;
        if (ruleDescr != null) {
            attributes = new HashMap<String, String>();
            for (AttributeDescr attribute : ruleDescr.getAttributes().values()) {
                if (attribute == null || attribute.getName() == null) continue;
                attributes.put(attribute.getName(), attribute.getValue());
            }
        }
        return attributes;
    }

    public void initRules() {
        this.rules = new HashMap<String, RuleDescr>();
        try {
            PackageDescr packageDescr;
            DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().parseResource(this.editor, true, false);
            if (drlInfo != null && (packageDescr = drlInfo.getPackageDescr()) != null) {
                for (RuleDescr ruleDescr : packageDescr.getRules()) {
                    if (ruleDescr == null || ruleDescr.getName() == null) continue;
                    this.rules.put(ruleDescr.getName(), ruleDescr);
                }
            }
        }
        catch (DroolsParserException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        GroupByRuleGroupAction groupByAction = new GroupByRuleGroupAction();
        menuManager.add((IAction)groupByAction);
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
    }

    class GroupByRuleGroupAction
    extends Action {
        public GroupByRuleGroupAction() {
            this.setText("Group by Rule Group");
            this.setToolTipText("Group by Rule Group");
            this.setDescription("Group by agenda-group, activation-group or ruleflow-group");
            this.setChecked(RuleContentOutlinePage.this.groupByRulegroup);
        }

        public void run() {
            this.setGroupByRuleGroup(!RuleContentOutlinePage.this.groupByRulegroup);
        }

        private void setGroupByRuleGroup(boolean groupBy) {
            RuleContentOutlinePage.this.groupByRulegroup = groupBy;
            this.setChecked(groupBy);
            IPreferenceStore preferenceStore = DroolsEclipsePlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue("GroupByRuleGroupAction.isChecked", groupBy);
            RuleContentOutlinePage.this.setContentProvider();
            RuleContentOutlinePage.this.viewer.refresh(true);
        }
    }
}

