/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.util.Arrays;
import java.util.List;
import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class AddNewActionDialog
extends RuleDialog {
    private RuleModeller modeller;

    public AddNewActionDialog(Shell parent, RuleModeller modeller) {
        super(parent, "Add a new action", "Pick the values from combos and confirm the selection.");
        this.modeller = modeller;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        String heading = "Choose...";
        this.createValuesOfFieldPart(composite, heading);
        this.createModifyFieldPart(composite, heading);
        this.createRetractFieldPart(composite, heading);
        String[] facts = this.getCompletion().getFactTypes();
        this.createFactAssertionPart(composite, heading, facts);
        this.createFactLogicalAssertionPart(composite, heading, facts);
        this.createDrlSentences(composite);
        return composite;
    }

    private void createDrlSentences(Composite composite) {
        this.createLabel(composite, "Free form action");
        Button b = new Button(composite, 0);
        b.setText("Add free form drl");
        b.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new FreeFormLine());
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private void createRetractFieldPart(Composite composite, String heading) {
        this.createLabel(composite, "Retract the fact");
        final Combo factsCombo = new Combo(composite, 8);
        factsCombo.add(heading);
        List boundFacts = this.modeller.getModel().getBoundFacts();
        int i = 0;
        while (i < boundFacts.size()) {
            factsCombo.add((String)boundFacts.get(i));
            ++i;
        }
        factsCombo.select(0);
        factsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (factsCombo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionRetractFact(factsCombo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private void createModifyFieldPart(Composite composite, String heading) {
        this.createLabel(composite, "Modify a field on a fact");
        final Combo factsCombo = new Combo(composite, 8);
        factsCombo.add(heading);
        List boundFacts = this.modeller.getModel().getBoundFacts();
        int i = 0;
        while (i < boundFacts.size()) {
            factsCombo.add((String)boundFacts.get(i));
            ++i;
        }
        factsCombo.select(0);
        factsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (factsCombo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionUpdateField(factsCombo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private void createDslSentences(Composite composite, String heading) {
        if (this.getCompletion().getDSLActions().length > 0) {
            this.createLabel(composite, "Actions");
            final Combo dslCombo = new Combo(composite, 8);
            dslCombo.add(heading);
            int i = 0;
            while (i < this.getCompletion().getDSLActions().length) {
                DSLSentence sen = this.getCompletion().getDSLActions()[i];
                dslCombo.add(sen.toString());
                ++i;
            }
            dslCombo.select(0);
            dslCombo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (dslCombo.getSelectionIndex() == 0) {
                        return;
                    }
                    DSLSentence sentence = AddNewActionDialog.this.getCompletion().getDSLActions()[dslCombo.getSelectionIndex() - 1];
                    AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)sentence.copy());
                    AddNewActionDialog.this.modeller.setDirty(true);
                    AddNewActionDialog.this.modeller.reloadRhs();
                    AddNewActionDialog.this.close();
                }
            });
        }
    }

    private void createFactLogicalAssertionPart(Composite composite, String heading, String[] facts) {
        this.createLabel(composite, "Logically insert a new fact");
        final Combo factsCombo = this.createFactsCombo(composite, heading, facts);
        factsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (factsCombo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionInsertLogicalFact(factsCombo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private void createFactAssertionPart(Composite composite, String heading, String[] facts) {
        this.createLabel(composite, "Assert a new fact");
        final Combo factsCombo = this.createFactsCombo(composite, heading, facts);
        factsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (factsCombo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionInsertFact(factsCombo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private Combo createFactsCombo(Composite composite, String heading, String[] facts) {
        Combo factsCombo = new Combo(composite, 8);
        factsCombo.add(heading);
        int i = 0;
        while (i < facts.length) {
            factsCombo.add(facts[i]);
            ++i;
        }
        factsCombo.select(0);
        return factsCombo;
    }

    private void createValuesOfFieldPart(Composite composite, String heading) {
        this.createLabel(composite, "Set the values of a field on");
        final Combo globalVarsCombo = new Combo(composite, 8);
        globalVarsCombo.add(heading);
        List boundFacts = this.modeller.getModel().getBoundFacts();
        String[] globals = this.modeller.getSuggestionCompletionEngine().getGlobalVariables();
        boundFacts.addAll(Arrays.asList(globals));
        int i = 0;
        while (i < boundFacts.size()) {
            globalVarsCombo.add((String)boundFacts.get(i));
            ++i;
        }
        globalVarsCombo.select(0);
        globalVarsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (globalVarsCombo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionSetField(globalVarsCombo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    public SuggestionCompletionEngine getCompletion() {
        return this.modeller.getSuggestionCompletionEngine();
    }
}

