/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class AddNewConditionDialog
extends RuleDialog {
    private IPattern pattern;
    private RuleModeller modeller;

    public AddNewConditionDialog(Shell parent, RuleModeller modeller) {
        super(parent, "Add new condition to the rule", "Pick the values from combos and confirm the selection.");
        this.modeller = modeller;
    }

    protected Control createDialogArea(Composite parent) {
        Control dialog = super.createDialogArea(parent);
        Composite composite = (Composite)dialog;
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.addFacts(composite);
        this.addConditionType(composite);
        this.addDSLSentences(composite);
        this.addFreeFormLine(composite);
        return composite;
    }

    private void addFreeFormLine(Composite composite) {
        this.createLabel(composite, "Free form action");
        Button b = new Button(composite, 0);
        b.setText("Add free form drl");
        b.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddNewConditionDialog.this.modeller.getModel().addLhsItem((IPattern)new FreeFormLine());
                AddNewConditionDialog.this.modeller.setDirty(true);
                AddNewConditionDialog.this.modeller.reloadLhs();
                AddNewConditionDialog.this.close();
            }
        });
    }

    private void addFacts(Composite composite) {
        this.createLabel(composite, "Fact");
        String[] factTypes = this.getCompletion().getFactTypes();
        final Combo factsCombo = new Combo(composite, 8);
        factsCombo.add("Choose fact type...");
        int i = 0;
        while (i < factTypes.length) {
            factsCombo.add(factTypes[i]);
            ++i;
        }
        factsCombo.select(0);
        factsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (factsCombo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewConditionDialog.this.modeller.getModel().addLhsItem((IPattern)new FactPattern(factsCombo.getText()));
                AddNewConditionDialog.this.modeller.reloadLhs();
                AddNewConditionDialog.this.modeller.setDirty(true);
                AddNewConditionDialog.this.close();
            }
        });
    }

    private void addConditionType(Composite composite) {
        this.createLabel(composite, "Condition type");
        final Combo conditionalsCombo = new Combo(composite, 8);
        String[] conditionalElements = this.getCompletion().getConditionalElements();
        conditionalsCombo.add("Choose condition type...");
        int i = 0;
        while (i < conditionalElements.length) {
            conditionalsCombo.add(conditionalElements[i]);
            ++i;
        }
        conditionalsCombo.select(0);
        conditionalsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (conditionalsCombo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewConditionDialog.this.modeller.getModel().addLhsItem((IPattern)new CompositeFactPattern(conditionalsCombo.getText()));
                AddNewConditionDialog.this.modeller.reloadLhs();
                AddNewConditionDialog.this.modeller.setDirty(true);
                AddNewConditionDialog.this.close();
            }
        });
    }

    private void addDSLSentences(Composite composite) {
        if (this.getCompletion().getDSLConditions().length > 0) {
            this.createLabel(composite, "Condition sentences");
            final Combo dslCombo = new Combo(composite, 8);
            dslCombo.add("Choose...");
            int i = 0;
            while (i < this.getCompletion().getDSLConditions().length) {
                DSLSentence sen = this.getCompletion().getDSLConditions()[i];
                dslCombo.add(sen.toString());
                ++i;
            }
            dslCombo.select(0);
            dslCombo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (dslCombo.getSelectionIndex() == 0) {
                        return;
                    }
                    DSLSentence sentence = AddNewConditionDialog.this.getCompletion().getDSLConditions()[dslCombo.getSelectionIndex() - 1];
                    AddNewConditionDialog.this.modeller.getModel().addLhsItem((IPattern)sentence.copy());
                    AddNewConditionDialog.this.modeller.reloadLhs();
                    AddNewConditionDialog.this.modeller.setDirty(true);
                    AddNewConditionDialog.this.close();
                }
            });
        }
    }

    public IPattern getPattern() {
        return this.pattern;
    }

    private SuggestionCompletionEngine getCompletion() {
        return this.modeller.getSuggestionCompletionEngine();
    }
}

