/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class Widget {
    protected final Composite parent;
    protected final FormToolkit toolkit;
    protected final RuleModeller modeller;
    protected final int index;

    public Widget(Composite parent, FormToolkit toolkit, RuleModeller modeller, int index) {
        this.parent = parent;
        this.toolkit = toolkit;
        this.modeller = modeller;
        this.index = index;
    }

    public ImageHyperlink addImage(Composite parent, String fileName) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(parent, 0);
        ImageDescriptor imageDescriptor = DroolsEclipsePlugin.getImageDescriptor(fileName);
        imageHyperlink.setImage(imageDescriptor.createImage());
        return imageHyperlink;
    }

    protected void addDeleteRHSAction() {
        ImageHyperlink delWholeLink = this.addImage(this.parent, "icons/delete_obj.gif");
        delWholeLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this action?");
                dialog.setText("Remove this action?");
                if (dialog.open() == 64) {
                    Widget.this.getModeller().getModel().removeRhsItem(Widget.this.index);
                    Widget.this.getModeller().setDirty(true);
                    Widget.this.getModeller().reloadRhs();
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        delWholeLink.setToolTipText("Remove this action.");
    }

    protected void showMessage(String msg) {
        MessageBox dialog = new MessageBox(Display.getDefault().getActiveShell(), 34);
        dialog.setMessage(msg);
        dialog.setText("Information");
        dialog.open();
    }

    protected RuleModeller getModeller() {
        return this.modeller;
    }
}

