/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import org.drools.eclipse.preferences.DroolsRuntimesBlock;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DroolsRuntimesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private DroolsRuntimesBlock droolsRuntimesBlock;

    public DroolsRuntimesPreferencePage() {
        super("Installed Drools Runtimes");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        Label l = new Label(ancestor, 64);
        l.setFont(ancestor.getFont());
        l.setText("Add, remove or edit Drools Runtime definitions. By default, the checked Drools Runtime is added to the build path of newly created Drools projects.");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 300;
        l.setLayoutData((Object)gd);
        l = new Label(ancestor, 0);
        gd = new GridData(768);
        gd.heightHint = 1;
        l.setLayoutData((Object)gd);
        this.droolsRuntimesBlock = new DroolsRuntimesBlock();
        this.droolsRuntimesBlock.createControl(ancestor);
        DroolsRuntime[] runtimes = DroolsRuntimeManager.getDroolsRuntimes();
        this.droolsRuntimesBlock.setDroolsRuntimes(runtimes);
        DroolsRuntime[] droolsRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime runtime = droolsRuntimeArray[n2];
            if (runtime.isDefault()) {
                this.droolsRuntimesBlock.setDefaultDroolsRuntime(runtime);
                break;
            }
            ++n2;
        }
        if (this.droolsRuntimesBlock.getDefaultDroolsRuntime() == null) {
            this.setErrorMessage("Select a default Drools Runtime");
        }
        Control control = this.droolsRuntimesBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.widthHint = 450;
        control.setLayoutData((Object)data);
        this.droolsRuntimesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DroolsRuntime runtime = DroolsRuntimesPreferencePage.this.droolsRuntimesBlock.getDefaultDroolsRuntime();
                if (runtime == null) {
                    DroolsRuntimesPreferencePage.this.setErrorMessage("Select a default Drools Runtime");
                } else {
                    DroolsRuntimesPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        if (DroolsRuntimeManager.getDefaultDroolsRuntime() != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Warning", (String)"You need to restart Eclipse to update the Drools Runtime of existing projects.");
        }
        DroolsRuntimeManager.setDroolsRuntimes(this.droolsRuntimesBlock.getDroolsRuntimes());
        return super.performOk();
    }
}

