/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementConnectionFactory;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.drools.eclipse.flow.common.editor.policy.ConnectionBendpointEditPolicy;
import org.drools.eclipse.flow.common.editor.policy.ConnectionEditPolicy;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;

public abstract class ElementConnectionEditPart
extends AbstractConnectionEditPart
implements ModelListener {
    protected void createEditPolicies() {
        ConnectionEditPolicy connectionEditPolicy = new ConnectionEditPolicy();
        connectionEditPolicy.setDefaultElementConnectionFactory(this.getDefaultElementConnectionFactory());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)connectionEditPolicy);
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ConnectionBendpointEditPolicy());
    }

    protected abstract ElementConnectionFactory getDefaultElementConnectionFactory();

    protected IFigure createFigure() {
        PolylineConnection result = new PolylineConnection();
        result.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        result.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        return result;
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(2);
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(1);
        }
    }

    public void modelChanged(ModelEvent event) {
        if (event.getChange() == 1) {
            this.refreshBendpoints();
        } else if (event.getChange() == 2) {
            this.refreshLabel();
        }
    }

    public void activate() {
        super.activate();
        ((ElementConnection)this.getModel()).addListener(this);
    }

    public void deactivate() {
        ((ElementConnection)this.getModel()).removeListener(this);
        super.deactivate();
    }

    protected void refreshLabel() {
    }

    protected void refreshBendpoints() {
        List<Point> bendpoints = ((ElementConnection)this.getModel()).getBendpoints();
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        int i = 0;
        while (i < bendpoints.size()) {
            constraint.add(new AbsoluteBendpoint(bendpoints.get(i)));
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    protected void refreshVisuals() {
        this.refreshLabel();
        this.refreshBendpoints();
    }
}

