/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.core.DefaultElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.NodeWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.metadata.MetaDataPropertyDescriptor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.NodeImpl;

public abstract class AbstractNodeWrapper
extends DefaultElementWrapper
implements NodeWrapper {
    private static final long serialVersionUID = 510L;
    public static IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[DefaultElementWrapper.DESCRIPTORS.length + 1];
    public static final String METADATA = "MetaData";

    static {
        System.arraycopy(DefaultElementWrapper.DESCRIPTORS, 0, DESCRIPTORS, 0, DefaultElementWrapper.DESCRIPTORS.length);
        AbstractNodeWrapper.DESCRIPTORS[AbstractNodeWrapper.DESCRIPTORS.length - 1] = new MetaDataPropertyDescriptor(METADATA, METADATA);
    }

    public void setNode(Node node) {
        this.setElement(node);
    }

    public Node getNode() {
        return (Node)this.getElement();
    }

    public String getId() {
        long id = this.getNode().getId();
        return id == -1L ? null : String.valueOf(this.getNode().getId());
    }

    public String getName() {
        return this.getNode().getName();
    }

    public void internalSetName(String name) {
        this.getNode().setName(name);
        this.notifyListeners(4);
    }

    public Color internalGetColor() {
        Integer rgb = (Integer)this.getNode().getMetaData("color");
        if (rgb != null) {
            return new Color((Device)Display.getCurrent(), AbstractNodeWrapper.integerToRGB(rgb));
        }
        return null;
    }

    protected void internalSetColor(Integer color) {
        this.getNode().setMetaData("color", (Object)color);
    }

    protected void internalSetConstraint(Rectangle constraint) {
        Node node = this.getNode();
        node.setMetaData("x", (Object)constraint.x);
        node.setMetaData("y", (Object)constraint.y);
        node.setMetaData("width", (Object)constraint.width);
        node.setMetaData("height", (Object)constraint.height);
    }

    public Rectangle internalGetConstraint() {
        Node node = this.getNode();
        Integer x = (Integer)node.getMetaData("x");
        Integer y = (Integer)node.getMetaData("y");
        Integer width = (Integer)node.getMetaData("width");
        Integer height = (Integer)node.getMetaData("height");
        return new Rectangle(x == null ? 0 : x, y == null ? 0 : y, width == null ? -1 : width, height == null ? -1 : height);
    }

    public boolean acceptsIncomingConnection(ElementConnection connection, ElementWrapper source) {
        return source == null || source.getParent() == this.getParent() || this.getParent() == source;
    }

    public boolean acceptsOutgoingConnection(ElementConnection connection, ElementWrapper target) {
        return target == null || ((NodeWrapper)target).getNode().getNodeContainer() == this.getNode().getNodeContainer() || ((NodeWrapper)target).getNode() == this.getNode().getNodeContainer();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Object getPropertyValue(Object id) {
        if (METADATA.equals(id)) {
            return ((NodeImpl)this.getNode()).getMetaData();
        }
        return super.getPropertyValue(id);
    }

    public void resetPropertyValue(Object id) {
        if (METADATA.equals(id)) {
            ((NodeImpl)this.getNode()).setMetaData(new HashMap());
        } else {
            super.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (METADATA.equals(id)) {
            ((NodeImpl)this.getNode()).setMetaData((Map)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

