/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.modeldriven.HumanReadable;
import org.drools.eclipse.rulebuilder.ui.AddNewInsertedFactFieldDialog;
import org.drools.eclipse.rulebuilder.ui.NumericKeyFilter;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ActionInsertFactWidget
extends Widget {
    private final ActionInsertFact fact;

    public ActionInsertFactWidget(FormToolkit toolkit, Composite parent, RuleModeller mod, ActionInsertFact fact, int index) {
        super(parent, toolkit, mod, index);
        this.fact = fact;
        GridLayout l = new GridLayout();
        l.numColumns = 4;
        l.marginBottom = 0;
        l.marginHeight = 0;
        l.marginLeft = 0;
        l.marginRight = 0;
        l.marginTop = 0;
        l.marginWidth = 0;
        l.verticalSpacing = 0;
        parent.setLayout((Layout)l);
        this.create();
    }

    private void create() {
        String assertType = "assert";
        if (this.fact instanceof ActionInsertLogicalFact) {
            assertType = "assertLogical";
        }
        this.toolkit.createLabel(this.parent, String.valueOf(HumanReadable.getActionDisplayName(assertType)) + " " + this.fact.factType);
        this.addDeleteRHSAction();
        this.addMoreOptionsAction();
        Composite constraintComposite = this.toolkit.createComposite(this.parent);
        GridLayout constraintLayout = new GridLayout();
        constraintLayout.numColumns = 3;
        constraintComposite.setLayout((Layout)constraintLayout);
        this.createConstraintRows(constraintComposite);
        this.toolkit.paintBordersFor(constraintComposite);
    }

    private void addMoreOptionsAction() {
        final Shell shell = new Shell(Display.getCurrent());
        ImageHyperlink link = this.addImage(this.parent, "icons/new_item.gif");
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                AddNewInsertedFactFieldDialog popup = new AddNewInsertedFactFieldDialog(shell, ActionInsertFactWidget.this.getModeller(), ActionInsertFactWidget.this.fact);
                popup.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        link.setToolTipText("Add another field to this so you can set its value");
    }

    private void createConstraintRows(Composite constraintComposite) {
        int row = 0;
        while (row < this.fact.fieldValues.length) {
            ActionFieldValue val = this.fact.fieldValues[row];
            this.toolkit.createLabel(constraintComposite, val.field);
            this.valueEditor(constraintComposite, val);
            this.addRemoveFieldAction(constraintComposite, row);
            ++row;
        }
    }

    private void addRemoveFieldAction(Composite constraintComposite, final int row) {
        ImageHyperlink delLink = this.addImage(constraintComposite, "icons/delete_item_small.gif");
        delLink.setToolTipText("Remove this field action");
        delLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this item?");
                dialog.setText("Remove this item?");
                if (dialog.open() == 64) {
                    ActionInsertFactWidget.this.fact.removeField(row);
                    ActionInsertFactWidget.this.getModeller().setDirty(true);
                    ActionInsertFactWidget.this.getModeller().reloadRhs();
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private void valueEditor(Composite parent, final ActionFieldValue val) {
        String cfr_ignored_0 = val.field;
        DropDownData enums = this.modeller.getSuggestionCompletionEngine().getEnums(this.fact.factType, val.field, (FieldNature[])this.fact.fieldValues);
        boolean found = false;
        if (enums != null && enums.fixedList.length > 0) {
            String[] list = enums.fixedList;
            final Combo combo = new Combo(parent, 12);
            int i = 0;
            while (i < list.length) {
                String e = list[i];
                combo.add(e);
                if (e.equals(val.value)) {
                    combo.select(i);
                    found = true;
                }
                ++i;
            }
            if (!found && val.value != null) {
                combo.add(val.value);
                combo.select(combo.getItemCount() - 1);
            }
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    val.value = combo.getItem(combo.getSelectionIndex());
                    ActionInsertFactWidget.this.modeller.reloadRhs();
                    ActionInsertFactWidget.this.modeller.setDirty(true);
                }
            });
        } else {
            final Text box = this.toolkit.createText(parent, "");
            if (val.value != null) {
                box.setText(val.value);
            }
            GridData gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            gd.minimumWidth = 100;
            box.setLayoutData((Object)gd);
            box.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ActionInsertFactWidget.this.getModeller().setDirty(true);
                    val.value = box.getText();
                }
            });
            if (val.type.equals("Numeric")) {
                new NumericKeyFilter(box);
            }
        }
    }

    public SuggestionCompletionEngine getCompletion() {
        return this.getModeller().getSuggestionCompletionEngine();
    }
}

