/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.WorkItemDefinitions;
import org.drools.eclipse.flow.common.editor.GenericModelEditor;
import org.drools.eclipse.flow.ruleflow.core.RuleFlowProcessWrapper;
import org.drools.eclipse.flow.ruleflow.core.RuleFlowWrapperBuilder;
import org.drools.eclipse.flow.ruleflow.core.StartNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.WorkItemWrapper;
import org.drools.eclipse.flow.ruleflow.editor.RuleFlowPaletteFactory;
import org.drools.eclipse.flow.ruleflow.editor.editpart.RuleFlowEditPartFactory;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.WorkDefinitionExtension;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jbpm.compiler.xml.ProcessSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.XmlRuleFlowProcessDumper;
import org.jbpm.compiler.xml.processes.RuleFlowMigrator;
import org.jbpm.ruleflow.core.RuleFlowProcess;

public class RuleFlowModelEditor
extends GenericModelEditor {
    protected EditPartFactory createEditPartFactory() {
        RuleFlowEditPartFactory factory = new RuleFlowEditPartFactory();
        factory.setProject(this.getJavaProject());
        return factory;
    }

    protected PaletteRoot createPalette() {
        return RuleFlowPaletteFactory.createPalette();
    }

    protected Object createModel() {
        RuleFlowProcessWrapper result = new RuleFlowProcessWrapper();
        StartNodeWrapper start = new StartNodeWrapper();
        start.setConstraint(new Rectangle(100, 100, -1, -1));
        result.addElement(start);
        start.setParent(result);
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        String name = file.getName();
        result.setName(name.substring(0, name.length() - 3));
        return result;
    }

    public RuleFlowProcessWrapper getRuleFlowModel() {
        return (RuleFlowProcessWrapper)this.getModel();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof IFileEditorInput) {
            this.refreshPalette(((IFileEditorInput)input).getFile());
        }
    }

    private void refreshPalette(IFile file) {
        if (this.getPaletteRoot().getChildren().size() <= 2) {
            return;
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            try {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                URLClassLoader newLoader = ProjectClassLoader.getProjectClassLoader(javaProject);
                try {
                    Thread.currentThread().setContextClassLoader(newLoader);
                    PaletteDrawer drawer = (PaletteDrawer)this.getPaletteRoot().getChildren().get(2);
                    ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
                    try {
                        for (final WorkDefinition workDefinition : WorkItemDefinitions.getWorkDefinitions((IResource)file).values()) {
                            String label;
                            String description = workDefinition.getName();
                            String icon = null;
                            if (workDefinition instanceof WorkDefinitionExtension) {
                                WorkDefinitionExtension extension = (WorkDefinitionExtension)workDefinition;
                                label = extension.getDisplayName();
                                description = extension.getExplanationText();
                                icon = extension.getIcon();
                            } else {
                                label = workDefinition.getName();
                            }
                            URL iconUrl = null;
                            if (icon != null) {
                                iconUrl = newLoader.getResource(icon);
                            }
                            if (iconUrl == null) {
                                iconUrl = DroolsEclipsePlugin.getDefault().getBundle().getEntry("icons/action.gif");
                            }
                            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(label, description, WorkItemWrapper.class, (CreationFactory)new SimpleFactory(WorkItemWrapper.class){

                                public Object getNewObject() {
                                    WorkItemWrapper workItemWrapper = (WorkItemWrapper)super.getNewObject();
                                    workItemWrapper.setName(label);
                                    workItemWrapper.setWorkDefinition(workDefinition);
                                    return workItemWrapper;
                                }
                            }, ImageDescriptor.createFromURL((URL)iconUrl), ImageDescriptor.createFromURL((URL)iconUrl));
                            entries.add(combined);
                        }
                    }
                    catch (Throwable t) {
                        DroolsEclipsePlugin.log(t);
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Parsing work item definitions", (String)t.getMessage());
                    }
                    drawer.setChildren(entries);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            catch (Exception e) {
                DroolsEclipsePlugin.log(e);
            }
        }
    }

    protected void writeModel(OutputStream os) throws IOException {
        this.writeModel(os, true);
    }

    protected void writeModel(OutputStream os, boolean includeGraphics) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        try {
            XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
            String out = dumper.dump((WorkflowProcess)this.getRuleFlowModel().getRuleFlowProcess(), includeGraphics);
            writer.write(out);
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
        writer.close();
    }

    protected void createModel(InputStream is) {
        try {
            InputStreamReader isr = new InputStreamReader(is);
            PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
            SemanticModules modules = configuration.getSemanticModules();
            modules.addSemanticModule((SemanticModule)new ProcessSemanticModule());
            XmlProcessReader xmlReader = new XmlProcessReader(modules, Thread.currentThread().getContextClassLoader());
            StringReader reader = null;
            try {
                List processes;
                String xml = RuleFlowMigrator.convertReaderToString((Reader)isr);
                if (RuleFlowMigrator.needToMigrateRFM((String)xml)) {
                    xml = RuleFlowMigrator.portRFToCurrentVersion((String)xml);
                    MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Incompatible RuleFlow Version", (String)"WARNING! The selected RuleFlow is Drools version 4 format.\n\nAny changes made to this RuleFlow will be saved in Drools 5 format, which is not compatible with Drools 4. To convert this RuleFlow to Drools 5 format, select Save As from the File menu and overwrite this file - the new RuleFlow file will be saved in Drools 5 format.");
                }
                if ((processes = xmlReader.read((Reader)(reader = new StringReader(xml)))) == null || processes.size() == 0) {
                    this.setModel(this.createModel());
                } else {
                    RuleFlowProcess process = (RuleFlowProcess)processes.get(0);
                    if (process == null) {
                        this.setModel(this.createModel());
                    } else {
                        this.setModel(new RuleFlowWrapperBuilder().getProcessWrapper((Process)process, this.getJavaProject()));
                    }
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Could not read RuleFlow file", (String)("An exception occurred while reading in the RuleFlow XML: " + t.getMessage() + " See the error log for more details."));
                this.setModel(this.createModel());
            }
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
    }
}

