/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.subprocess;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.workflow.core.node.SubProcessNode;

public class SubProcessParameterOutMappingDialog
extends EditBeanDialog
implements FocusListener,
MouseListener {
    private Table table;
    private Button removeButton;
    private Text text;
    private TableEditor editor;
    private int selectedColumn = -1;

    public SubProcessParameterOutMappingDialog(Shell parentShell, SubProcessNode subProcessNode) {
        super(parentShell, "Parameter Out Mapping");
        this.setValue(subProcessNode.getOutMappings());
    }

    protected Object updateValue(Object value) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            mapping.put(item.getText(1), item.getText(0));
            ++n2;
        }
        return mapping;
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.table = new Table(composite, 4);
        GridData gd = new GridData();
        gd.verticalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.table.setLayoutData((Object)gd);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SubProcessParameterOutMappingDialog.this.removeButton.setEnabled(SubProcessParameterOutMappingDialog.this.table.getSelectionIndex() != -1);
            }

            public void widgetSelected(SelectionEvent e) {
                SubProcessParameterOutMappingDialog.this.removeButton.setEnabled(SubProcessParameterOutMappingDialog.this.table.getSelectionIndex() != -1);
            }
        });
        this.table.addMouseListener((MouseListener)this);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn variableNameColumn = new TableColumn(this.table, 16384);
        variableNameColumn.setText("Process Variable");
        variableNameColumn.setWidth(150);
        TableColumn parameterNameColumn = new TableColumn(this.table, 16384);
        parameterNameColumn.setText("Sub Process Variable");
        parameterNameColumn.setWidth(225);
        this.editor = new TableEditor(this.table);
        this.text = new Text((Composite)this.table, 0);
        this.text.setVisible(false);
        this.text.setText("");
        this.editor.minimumWidth = this.text.getSize().x;
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        Button addButton = new Button(composite, 8);
        addButton.setText("Add");
        addButton.setFont(JFaceResources.getDialogFont());
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SubProcessParameterOutMappingDialog.this.addButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        addButton.setLayoutData((Object)gd);
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setFont(JFaceResources.getDialogFont());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SubProcessParameterOutMappingDialog.this.removeButtonPressed();
            }
        });
        gd = new GridData();
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.setEnabled(false);
        this.updateTable();
        return composite;
    }

    private void updateTable() {
        Map mapping = (Map)this.getValue();
        for (Map.Entry entry : mapping.entrySet()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{(String)entry.getValue(), (String)entry.getKey()});
        }
    }

    private void addButtonPressed() {
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, "variable");
        item.setText(1, "variable");
        this.table.setSelection(item);
    }

    private void removeButtonPressed() {
        int i = this.table.getSelectionIndex();
        if (i == -1) {
            return;
        }
        this.table.remove(i);
        this.removeButton.setEnabled(this.table.getItemCount() == 0);
    }

    private void doEdit() {
        if (this.text.isVisible()) {
            this.endEdit();
        }
        if (this.table.getSelectionIndex() == -1 || this.selectedColumn == -1) {
            return;
        }
        TableItem selection = this.table.getItem(this.table.getSelectionIndex());
        String value = selection.getText(this.selectedColumn);
        this.text.setText(value == null ? "" : value);
        this.editor.setEditor((Control)this.text, selection, this.selectedColumn);
        this.text.setVisible(true);
        this.text.selectAll();
        this.text.setFocus();
        this.text.addFocusListener((FocusListener)this);
    }

    private void endEdit() {
        this.text.setVisible(false);
        this.text.setText("");
        this.text.removeFocusListener((FocusListener)this);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.text) {
            this.applyValue();
            this.endEdit();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.selectedColumn = this.getSelectedColumn(e.x, e.y);
        if (this.selectedColumn == -1) {
            return;
        }
        this.doEdit();
    }

    public void mouseUp(MouseEvent e) {
    }

    private int getSelectedColumn(int x, int y) {
        int columnToEdit = -1;
        int columns = this.table.getColumnCount();
        if (this.table.getSelection().length == 0) {
            return -1;
        }
        int i = 0;
        while (i < columns) {
            Rectangle bounds = this.table.getSelection()[0].getBounds(i);
            if (bounds.contains(x, y)) {
                columnToEdit = i;
                break;
            }
            ++i;
        }
        return columnToEdit;
    }

    private void applyValue() {
        int i = this.table.getSelectionIndex();
        if (i == -1) {
            return;
        }
        TableItem item = this.table.getItem(i);
        item.setText(this.selectedColumn, this.text.getText());
    }
}

