/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.builder;

import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.builder.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.kie.io.Resource;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;

public class ResourceDescr {
    private IResource resource;
    private ResourceType type;
    private String content;
    private Resource droolsResource;

    public static ResourceDescr createResourceDescr(IResource resource) {
        if (!(resource instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)resource;
        ResourceDescr descr = new ResourceDescr();
        descr.resource = resource;
        descr.type = ResourceType.determineResourceType((String)resource.getName());
        if (descr.type == null) {
            return null;
        }
        try {
            descr.content = new String(Util.getResourceContentsAsCharArray(file));
            descr.droolsResource = ResourceFactory.newInputStreamResource((InputStream)file.getContents());
        }
        catch (Exception e) {
            DroolsEclipsePlugin.log(e);
            return null;
        }
        return descr;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getSourcePathName() {
        return this.resource.getFullPath().removeFirstSegments(1).toString();
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public Resource getContentAsDroolsResource() {
        return this.droolsResource;
    }

    public String toString() {
        return this.resource.getName();
    }
}

