/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.DroolsDebugEventHandlerView;
import org.drools.eclipse.debug.DroolsDebugViewContentProvider;
import org.drools.eclipse.debug.VariableWrapper;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;

public class ApplicationDataViewContentProvider
extends DroolsDebugViewContentProvider {
    private DroolsDebugEventHandlerView view;

    public ApplicationDataViewContentProvider(DroolsDebugEventHandlerView view) {
        this.view = view;
    }

    @Override
    protected String getEmptyString() {
        return "The selected working memory has no globals defined.";
    }

    @Override
    public Object[] getChildren(Object obj) {
        try {
            IVariable[] variables = null;
            if (obj != null && obj instanceof IJavaObject && "org.drools.reteoo.ReteooStatefulSession".equals(((IJavaObject)obj).getReferenceTypeName())) {
                variables = this.getApplicationDataElements((IJavaObject)obj);
            } else if (obj instanceof IVariable) {
                if (this.view.isShowLogicalStructure()) {
                    IValue value = this.getLogicalValue(((IVariable)obj).getValue(), new ArrayList());
                    variables = value.getVariables();
                }
                if (variables == null) {
                    variables = ((IVariable)obj).getValue().getVariables();
                }
            }
            if (variables == null) {
                return new Object[0];
            }
            this.cache(obj, variables);
            return variables;
        }
        catch (DebugException e) {
            DroolsEclipsePlugin.log(e);
            return new Object[0];
        }
    }

    private IVariable[] getApplicationDataElements(IJavaObject stackObj) throws DebugException {
        IValue objects = DebugUtil.getValueByExpression("return ((org.drools.base.MapGlobalResolver) getGlobalResolver()).getGlobals();", (IValue)stackObj);
        if (objects instanceof IJavaArray) {
            IJavaArray array = (IJavaArray)objects;
            ArrayList<VariableWrapper> result = new ArrayList<VariableWrapper>();
            IJavaValue[] javaVals = array.getValues();
            int i = 0;
            while (i < javaVals.length) {
                IJavaValue mapEntry = javaVals[i];
                String key = null;
                IJavaValue value = null;
                IVariable[] vars = mapEntry.getVariables();
                int j = 0;
                while (j < vars.length) {
                    IVariable var = vars[j];
                    if ("key".equals(var.getName())) {
                        key = var.getValue().getValueString();
                    } else if ("value".equals(var.getName())) {
                        value = (IJavaValue)var.getValue();
                    }
                    ++j;
                }
                result.add(new VariableWrapper(key, value));
                ++i;
            }
            return result.toArray(new IVariable[result.size()]);
        }
        return null;
    }
}

