/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor.completion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.dsl.editor.DSLAdapter;
import org.drools.eclipse.dsl.editor.DSLRuleEditor;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.completion.RuleCompletionProcessor;
import org.drools.eclipse.editors.completion.RuleCompletionProposal;
import org.drools.lang.Location;
import org.eclipse.swt.graphics.Image;

public class DSLRuleCompletionProcessor
extends RuleCompletionProcessor {
    private static final Image DSL_ICON = DroolsPluginImages.getImage("DslExpression");

    public DSLRuleCompletionProcessor(AbstractRuleEditor editor) {
        super(editor);
    }

    protected DSLRuleEditor getDSLRuleEditor() {
        return (DSLRuleEditor)this.getEditor();
    }

    @Override
    protected void addRHSCompletionProposals(List list, int documentOffset, String prefix, String backText, String conditions, String consequence) {
        DSLAdapter adapter = this.getDSLRuleEditor().getDSLAdapter();
        if (adapter != null) {
            ArrayList dslConsequences = adapter.getDSLTree().getConsequenceChildrenList(prefix, true);
            this.addDSLProposals(list, documentOffset, prefix, dslConsequences);
        }
    }

    protected void addLHSCompletionProposals(List list, int documentOffset, Location location, String prefix, String backText) {
        DSLAdapter adapter = this.getDSLRuleEditor().getDSLAdapter();
        if (adapter != null) {
            String lastobj = this.getLastNonDashLine(backText);
            String last = this.getLastLine(backText);
            boolean firstLine = false;
            if (lastobj.equals("when")) {
                firstLine = true;
                last = "";
                lastobj = "*";
            }
            last = last.trim();
            List dslConditions = this.getProposals(adapter, lastobj, last, firstLine);
            this.addDSLProposals(list, documentOffset, last, dslConditions);
        }
    }

    private void addDSLProposals(List list, int documentOffset, String prefix, List dslItems) {
        for (String consequence : dslItems) {
            RuleCompletionProposal p = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), consequence);
            p.setImage(DSL_ICON);
            list.add(p);
        }
    }

    public String getLastLine(String backText) {
        BufferedReader breader = new BufferedReader(new StringReader(backText));
        String last = "";
        String line = null;
        try {
            while ((line = breader.readLine()) != null) {
                if (line.length() <= 0) continue;
                last = line;
            }
        }
        catch (IOException e) {
            DroolsEclipsePlugin.log(e);
        }
        if (last.indexOf("(") > -1) {
            last = last.substring(last.lastIndexOf("(") + 1);
        }
        if (last.indexOf(",") > -1) {
            last = last.substring(last.lastIndexOf(",") + 1);
        }
        if (last.endsWith(")")) {
            last = "";
        }
        return last;
    }

    public String getLastNonDashLine(String backText) {
        BufferedReader breader = new BufferedReader(new StringReader(backText));
        String last = "";
        String line = null;
        try {
            while ((line = breader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("-")) continue;
                last = line;
            }
        }
        catch (IOException e) {
            DroolsEclipsePlugin.log(e);
        }
        if (last.indexOf("(") > -1 && !last.endsWith(")")) {
            last = last.substring(0, last.indexOf("("));
        } else if (last.indexOf("(") > -1 && last.endsWith(")")) {
            last = "";
        }
        return last;
    }

    protected List getProposals(DSLAdapter adapter, String obj, String last, boolean firstLine) {
        if (last.length() == 0) {
            last = " ";
        }
        return adapter.getDSLTree().getChildrenList(obj, last, true, firstLine);
    }
}

