/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.AbstractNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.ConnectionWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.ConstraintsPropertyDescriptor;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.node.Split;
import org.kie.definition.process.Connection;

public class SplitWrapper
extends AbstractNodeWrapper {
    public static final int CHANGE_TYPE = 5;
    public static final String TYPE = "type";
    public static final String CONSTRAINTS = "constraints";
    private static final long serialVersionUID = 510L;
    private transient IPropertyDescriptor[] descriptors;

    public SplitWrapper() {
        this.setNode((Node)new Split());
        this.getSplit().setName("Split");
        this.setDescriptors();
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        for (Connection connection : this.getSplit().getDefaultOutgoingConnections()) {
            String label = null;
            Constraint constraint = this.getSplit().internalGetConstraint(new ConnectionRef(connection.getTo().getId(), connection.getToType()));
            if (constraint != null) {
                label = constraint.getName();
            }
            ((org.jbpm.workflow.core.Connection)connection).setMetaData("label", (Object)label);
        }
    }

    private void updateConnectionLabels() {
        for (ElementConnection connection : this.getOutgoingConnections()) {
            this.updateConnectionLabel(connection);
        }
    }

    private void updateConnectionLabel(ElementConnection connection) {
        ConnectionWrapper connectionWrapper = (ConnectionWrapper)connection;
        String label = null;
        Constraint constraint = this.getSplit().internalGetConstraint(new ConnectionRef(connectionWrapper.getConnection().getTo().getId(), connectionWrapper.getConnection().getToType()));
        if (constraint != null) {
            label = constraint.getName();
        }
        connectionWrapper.getConnection().setMetaData("label", (Object)label);
        connectionWrapper.notifyListeners(2);
    }

    private void setDescriptors() {
        this.descriptors = new IPropertyDescriptor[AbstractNodeWrapper.DESCRIPTORS.length + 1];
        System.arraycopy(AbstractNodeWrapper.DESCRIPTORS, 0, this.descriptors, 0, AbstractNodeWrapper.DESCRIPTORS.length);
        this.descriptors[this.descriptors.length - 1] = new ComboBoxPropertyDescriptor((Object)TYPE, "Type", new String[]{"", "AND", "XOR", "OR"});
    }

    public Split getSplit() {
        return (Split)this.getNode();
    }

    @Override
    public boolean acceptsIncomingConnection(ElementConnection connection, ElementWrapper source) {
        return super.acceptsIncomingConnection(connection, source) && this.getIncomingConnections().isEmpty();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getParent() != null && (this.getSplit().getType() == 2 || this.getSplit().getType() == 3)) {
            IPropertyDescriptor[] result = new IPropertyDescriptor[this.descriptors.length + 1];
            System.arraycopy(this.descriptors, 0, result, 0, this.descriptors.length);
            result[this.descriptors.length] = new ConstraintsPropertyDescriptor(CONSTRAINTS, "Constraints", this.getSplit(), (WorkflowProcess)this.getParent().getProcessWrapper().getProcess());
            return result;
        }
        return this.descriptors;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (TYPE.equals(id)) {
            return new Integer(this.getSplit().getType());
        }
        if (CONSTRAINTS.equals(id)) {
            return this.getSplit().getType() == 2 || this.getSplit().getType() == 3 ? new MyHashMap(this.getSplit().getConstraints()) : new MyHashMap();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void resetPropertyValue(Object id) {
        if (TYPE.equals(id)) {
            this.getSplit().setType(0);
            this.notifyListeners(5);
            this.updateConnectionLabels();
        } else if (CONSTRAINTS.equals(id)) {
            for (Connection connection : this.getSplit().getDefaultOutgoingConnections()) {
                this.getSplit().setConstraint(connection, null);
            }
            this.updateConnectionLabels();
        } else {
            super.resetPropertyValue(id);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (TYPE.equals(id)) {
            this.getSplit().setType(((Integer)value).intValue());
            this.notifyListeners(5);
            this.updateConnectionLabels();
        } else if (CONSTRAINTS.equals(id)) {
            for (Map.Entry element : ((Map)value).entrySet()) {
                ConnectionRef connectionRef = (ConnectionRef)element.getKey();
                Connection outgoingConnection = null;
                for (Connection out : this.getSplit().getDefaultOutgoingConnections()) {
                    if (!out.getToType().equals(connectionRef.getToType()) || out.getTo().getId() != connectionRef.getNodeId()) continue;
                    outgoingConnection = out;
                }
                if (outgoingConnection == null) {
                    throw new IllegalArgumentException("Could not find outgoing connection");
                }
                this.getSplit().setConstraint(outgoingConnection, (Constraint)element.getValue());
            }
            this.updateConnectionLabels();
        } else {
            super.setPropertyValue(id, value);
        }
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.setDescriptors();
    }

    public class MyHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 510L;

        public MyHashMap() {
        }

        public MyHashMap(Map<K, V> map) {
            super(map);
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

