/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.variable;

import org.drools.eclipse.flow.common.datatype.DefaultDataTypeRegistry;
import org.drools.eclipse.flow.common.view.datatype.editor.DataTypeEditor;
import org.drools.eclipse.flow.common.view.datatype.editor.impl.DataTypeCombo;
import org.drools.eclipse.flow.common.view.datatype.editor.impl.DataTypeEditorComposite;
import org.drools.eclipse.flow.common.view.datatype.editor.impl.EditorComposite;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.process.core.datatype.DataType;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jbpm.process.core.context.variable.Variable;

public class VariableDialog
extends EditBeanDialog<Variable> {
    private Text nameText;
    private DataTypeCombo dataTypeCombo;
    private DataTypeEditorComposite dataTypeEditorComposite;
    private EditorComposite editorComposite;

    public VariableDialog(Shell parentShell) {
        super(parentShell, "Edit Variable");
    }

    protected Control createDialogArea(Composite parent) {
        final Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name: ");
        this.nameText = new Text(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gridData);
        String name = ((Variable)this.getValue()).getName();
        this.nameText.setText(name == null ? "" : name);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText("Type: ");
        this.dataTypeCombo = new DataTypeCombo(composite, 0, DefaultDataTypeRegistry.getInstance());
        DataType dataType = ((Variable)this.getValue()).getType();
        this.dataTypeCombo.setDataType(dataType);
        this.dataTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataType dataType = VariableDialog.this.dataTypeCombo.getDataType();
                VariableDialog.this.dataTypeEditorComposite.setDataType(dataType);
                VariableDialog.this.editorComposite.setDataType(dataType);
                composite.layout();
            }
        });
        new Label(composite, 0);
        this.dataTypeEditorComposite = new DataTypeEditorComposite(composite, 0, DefaultDataTypeRegistry.getInstance());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.dataTypeEditorComposite.setLayoutData(gridData);
        this.dataTypeEditorComposite.setDataType(dataType);
        this.dataTypeEditorComposite.addListener(new DataTypeEditor.DataTypeListener(){

            @Override
            public void dataTypeChanged(DataType dataType) {
                VariableDialog.this.editorComposite.setDataType(dataType);
                composite.layout();
            }
        });
        Label valueLabel = new Label(composite, 0);
        valueLabel.setText("Value: ");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        valueLabel.setLayoutData((Object)gridData);
        this.editorComposite = new EditorComposite(composite, 0, DefaultDataTypeRegistry.getInstance());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.editorComposite.setLayoutData(gridData);
        this.editorComposite.setDataType(dataType);
        this.editorComposite.setValue(((Variable)this.getValue()).getValue());
        Composite bottom = new Composite(composite, 0);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        bottom.setLayoutData((Object)gridData);
        return composite;
    }

    @Override
    protected Variable updateValue(Variable value) {
        Variable variable = (Variable)this.getValue();
        String name = this.nameText.getText();
        if ("".equals(name)) {
            throw new IllegalArgumentException("Name should not be empty");
        }
        variable.setName(name);
        variable.setType(this.dataTypeEditorComposite.getDataType());
        variable.setValue(this.editorComposite.getValue());
        return variable;
    }
}

