/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.BooleanDataType;
import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BooleanEditor
extends Composite
implements Editor {
    private static final String[] TF = new String[]{"true", "false"};
    private Combo combo;

    public BooleanEditor(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.combo = new Combo((Composite)this, 8);
        this.combo.setItems(TF);
        this.combo.select(1);
    }

    @Override
    public void setDataType(DataType dataType) {
        if (!(dataType instanceof BooleanDataType)) {
            throw new IllegalArgumentException("Illegal data type " + dataType);
        }
    }

    @Override
    public Object getValue() {
        return this.combo.getSelectionIndex() == 0;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.combo.select(1);
        } else if (value instanceof Boolean) {
            this.combo.select((Boolean)value != false ? 0 : 1);
        } else {
            throw new IllegalArgumentException("Value must be a boolean: " + value);
        }
    }

    @Override
    public void reset() {
        this.combo.select(1);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.combo.setEnabled(enabled);
    }
}

