/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.actions.ShowLogicalStructureAction;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class DroolsDebugEventHandlerView
extends AbstractDebugView
implements IDebugContextListener,
ISelectionListener {
    private VariablesViewModelPresentation modelPresentation;
    private boolean showLogical = true;
    private Object[] oldExpandedElements = new Object[0];

    public void dispose() {
        DebugContextManager.getDefault().removeDebugContextListener((IDebugContextListener)this);
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.VariableView", (ISelectionListener)this);
        super.dispose();
    }

    public boolean isShowLogicalStructure() {
        return this.showLogical;
    }

    public void setShowLogicalStructure(boolean showLogical) {
        this.showLogical = showLogical;
    }

    protected void setViewerInput(Object context) {
        Object current;
        Object selection;
        ISelection stackSelection;
        IDebugContextService debugContextService;
        IValue input = null;
        if (context instanceof IVariable) {
            IVariable variable = (IVariable)context;
            try {
                IValue value = ((IVariable)context).getValue();
                if (value != null && value instanceof IJavaObject) {
                    IJavaFieldVariable sessionVar;
                    if ("org.drools.core.common.AbstartWorkingMemory".equals(variable.getValue().getReferenceTypeName()) || "org.drools.core.reteoo.ReteooStatefulSession".equals(variable.getValue().getReferenceTypeName()) || "org.drools.reteoo.ReteooStatefulSession".equals(variable.getValue().getReferenceTypeName())) {
                        input = value;
                    } else if (("org.drools.core.impl.StatefulKnowledgeSessionImpl".equals(variable.getValue().getReferenceTypeName()) || "org.drools.impl.StatefulKnowledgeSessionImpl".equals(variable.getValue().getReferenceTypeName())) && (sessionVar = ((IJavaObject)value).getField("session", false)) != null) {
                        input = sessionVar.getValue();
                    }
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
        if (input == null && (debugContextService = DebugContextManager.getDefault().getContextService(this.getSite().getWorkbenchWindow())) != null && (stackSelection = debugContextService.getActiveContext()) instanceof IStructuredSelection && (selection = ((IStructuredSelection)stackSelection).getFirstElement()) instanceof IJavaStackFrame) {
            try {
                IJavaThread thread = (IJavaThread)((IJavaStackFrame)selection).getThread();
                IStackFrame[] frames = thread.getStackFrames();
                int i = 0;
                while (i < frames.length) {
                    IJavaObject stackObj = ((IJavaStackFrame)frames[i]).getThis();
                    if (stackObj != null && stackObj.getJavaType() != null && ("org.drools.core.common.AbstractWorkingMemory".equals(stackObj.getJavaType().getName()) || "org.drools.core.reteoo.ReteooStatefulSession".equals(stackObj.getJavaType().getName()) || "org.drools.reteoo.ReteooStatefulSession".equals(stackObj.getJavaType().getName()) || "org.drools.core.impl.StatefulKnowledgeSessionImpl".equals(stackObj.getJavaType().getName()))) {
                        input = stackObj;
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
        if ((current = this.getViewer().getInput()) == null && input == null) {
            return;
        }
        Object[] newExpandedElements = ((TreeViewer)this.getViewer()).getExpandedElements();
        if (newExpandedElements.length != 0) {
            this.oldExpandedElements = newExpandedElements;
        }
        this.getViewer().setInput(input);
        if (input != null) {
            ((TreeViewer)this.getViewer()).setExpandedElements(this.oldExpandedElements);
            ((TreeViewer)this.getViewer()).expandToLevel(this.getAutoExpandLevel());
        }
    }

    protected Viewer createViewer(Composite parent) {
        TreeViewer variablesViewer = new TreeViewer(parent);
        variablesViewer.setContentProvider(this.createContentProvider());
        variablesViewer.setLabelProvider((IBaseLabelProvider)new VariablesViewLabelProvider(this.getModelPresentation()));
        variablesViewer.setUseHashlookup(true);
        DebugContextManager.getDefault().addDebugContextListener((IDebugContextListener)this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.VariableView", (ISelectionListener)this);
        return variablesViewer;
    }

    protected int getAutoExpandLevel() {
        return 0;
    }

    protected abstract IContentProvider createContentProvider();

    protected String getHelpContextId() {
        return null;
    }

    protected void becomesHidden() {
        this.setViewerInput(null);
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.VariableView");
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput(((IStructuredSelection)selection).getFirstElement());
        } else {
            this.setViewerInput(null);
        }
    }

    protected void createActions() {
        ShowLogicalStructureAction action = new ShowLogicalStructureAction(this);
        this.setAction("ShowLogicalStructure", (IAction)action);
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add(this.getAction("ShowLogicalStructure"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("additions"));
    }

    public void contextActivated(ISelection selection, IWorkbenchPart part) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput(((IStructuredSelection)selection).getFirstElement());
        }
        this.showViewer();
    }

    public void debugContextChanged(DebugContextEvent event) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isAvailable()) {
            return;
        }
        if (part instanceof VariablesView) {
            selection = ((VariablesView)part).getCurrentSelection();
        }
        if (selection == null) {
            this.setViewerInput(null);
        } else if (selection instanceof IStructuredSelection) {
            this.setViewerInput(((IStructuredSelection)selection).getFirstElement());
        }
    }

    protected void initActionState(IAction action) {
        String id = action.getId();
        if (id.endsWith("ShowLogicalStructureAction")) {
            action.setChecked(true);
        } else {
            super.initActionState(action);
        }
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.modelPresentation == null) {
            this.modelPresentation = new VariablesViewModelPresentation();
        }
        return this.modelPresentation;
    }

    private class VariablesViewLabelProvider
    implements ILabelProvider,
    IColorProvider {
        private IDebugModelPresentation presentation;

        public VariablesViewLabelProvider(IDebugModelPresentation presentation) {
            this.presentation = presentation;
        }

        public IDebugModelPresentation getPresentation() {
            return this.presentation;
        }

        public Image getImage(Object element) {
            return this.presentation.getImage(element);
        }

        public String getText(Object element) {
            return this.presentation.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.presentation.addListener(listener);
        }

        public void dispose() {
            this.presentation.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.presentation.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.presentation.removeListener(listener);
        }

        public Color getForeground(Object element) {
            if (element instanceof IVariable) {
                IVariable variable = (IVariable)element;
                try {
                    if (variable.hasValueChanged()) {
                        return JFaceResources.getColorRegistry().get("org.eclipse.debug.ui.changedDebugElement");
                    }
                }
                catch (DebugException e) {
                    DroolsEclipsePlugin.log(e);
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

