/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.DroolsDebugEventHandlerView;
import org.drools.eclipse.debug.DroolsDebugViewContentProvider;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaModifiers;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class WorkingMemoryViewContentProvider
extends DroolsDebugViewContentProvider {
    private DroolsDebugEventHandlerView view;

    public WorkingMemoryViewContentProvider(DroolsDebugEventHandlerView view) {
        this.view = view;
    }

    @Override
    protected String getEmptyString() {
        return "The selected working memory is empty.";
    }

    @Override
    public Object[] getChildren(Object obj) {
        try {
            IVariable[] variables = null;
            if (obj != null && obj instanceof IJavaObject && ("org.drools.core.common.AbstractWorkingMemory".equals(((IJavaObject)obj).getReferenceTypeName()) || "org.drools.core.reteoo.ReteooStatefulSession".equals(((IJavaObject)obj).getReferenceTypeName()) || "org.drools.reteoo.ReteooStatefulSession".equals(((IJavaObject)obj).getReferenceTypeName()))) {
                variables = this.getWorkingMemoryElements((IJavaObject)obj);
            } else if (obj instanceof IVariable) {
                if (this.view.isShowLogicalStructure()) {
                    IValue value = this.getLogicalValue(((IVariable)obj).getValue(), new ArrayList());
                    variables = value.getVariables();
                }
                if (variables == null) {
                    variables = ((IVariable)obj).getValue().getVariables();
                }
            }
            if (variables == null) {
                return new Object[0];
            }
            this.cache(obj, variables);
            return variables;
        }
        catch (DebugException e) {
            DroolsEclipsePlugin.log(e);
            return new Object[0];
        }
    }

    private IVariable[] getWorkingMemoryElements(IJavaObject stackObj) throws DebugException {
        IValue objects = DebugUtil.getValueByExpression("return iterateObjectsToList().toArray();", (IValue)stackObj);
        if (objects instanceof IJavaArray) {
            IJavaArray array = (IJavaArray)objects;
            ArrayList<MyJavaVariable> result = new ArrayList<MyJavaVariable>();
            IJavaValue[] vals = array.getValues();
            int i = 0;
            while (i < vals.length) {
                result.add(new MyJavaVariable("[" + i + "]", vals[i]));
                ++i;
            }
            return result.toArray(new IVariable[0]);
        }
        return null;
    }

    public class MyJavaVariable
    implements IJavaVariable {
        private String name;
        private IJavaValue value;

        public MyJavaVariable(String name, IJavaValue value) {
            this.name = name;
            this.value = value;
        }

        public String getSignature() throws DebugException {
            return ((IJavaValue)this.getValue()).getSignature();
        }

        public String getGenericSignature() throws DebugException {
            return ((IJavaValue)this.getValue()).getGenericSignature();
        }

        public IJavaType getJavaType() throws DebugException {
            return ((IJavaValue)this.getValue()).getJavaType();
        }

        public boolean isLocal() {
            return false;
        }

        public IValue getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String getReferenceTypeName() throws DebugException {
            return ((IJavaValue)this.getValue()).getReferenceTypeName();
        }

        public boolean hasValueChanged() {
            return false;
        }

        public boolean isPublic() {
            return false;
        }

        public boolean isPrivate() {
            return false;
        }

        public boolean isProtected() {
            return false;
        }

        public boolean isPackagePrivate() {
            return false;
        }

        public boolean isFinal() {
            return false;
        }

        public boolean isStatic() {
            return false;
        }

        public boolean isSynthetic() {
            return false;
        }

        public String getModelIdentifier() {
            return this.getValue().getModelIdentifier();
        }

        public IDebugTarget getDebugTarget() {
            return ((IJavaValue)this.getValue()).getDebugTarget();
        }

        public ILaunch getLaunch() {
            return this.getValue().getLaunch();
        }

        public void setValue(String expression) {
        }

        public void setValue(IValue value) {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(String expression) {
            return false;
        }

        public boolean verifyValue(IValue value) {
            return false;
        }

        public Object getAdapter(Class adapter) {
            if (IJavaVariable.class.equals((Object)adapter) || IJavaModifiers.class.equals((Object)adapter)) {
                return this;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MyJavaVariable) {
                MyJavaVariable var = (MyJavaVariable)obj;
                return var.getName().equals(this.getName()) && var.getValue().equals(this.getValue());
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.value.hashCode();
        }
    }
}

