/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.eclipse.flow.common.view.datatype.editor.DataTypeEditor;
import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ObjectDataTypeEditor
extends Composite
implements Editor,
DataTypeEditor {
    private ObjectDataType dataType;
    private Object value;
    private Label label;
    private Text text;
    private List<DataTypeEditor.DataTypeListener> listeners = new ArrayList<DataTypeEditor.DataTypeListener>();

    public ObjectDataTypeEditor(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.label = new Label((Composite)this, 0);
        this.label.setText("ClassName");
        this.text = new Text((Composite)this, 0);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectDataTypeEditor.this.notifyListeners();
            }
        });
    }

    @Override
    public DataType getDataType() {
        this.dataType.setClassName(this.text.getText());
        return this.dataType;
    }

    @Override
    public void setDataType(DataType dataType) {
        this.dataType = (ObjectDataType)dataType;
        String className = this.dataType.getClassName();
        this.text.setText(className == null ? "" : className);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void reset() {
        this.text.setText("");
    }

    @Override
    public void addListener(DataTypeEditor.DataTypeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DataTypeEditor.DataTypeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (DataTypeEditor.DataTypeListener listener : this.listeners) {
            listener.dataTypeChanged(this.getDataType());
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.label.setBackground(color);
    }
}

