/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.action;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.wizard.project.NewDroolsProjectWizard;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertToDroolsProjectAction
implements IObjectActionDelegate {
    private IJavaProject project;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.project != null && this.project.exists()) {
            try {
                ConvertToDroolsProjectAction.addDroolsBuilder(this.project, null);
                ConvertToDroolsProjectAction.addDroolsLibraries(this.project, null);
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            IJavaProject javaProject;
            Object element = structured.getFirstElement();
            if (element instanceof IJavaProject) {
                this.project = (IJavaProject)element;
            } else if (element instanceof IProject && (javaProject = JavaCore.create((IProject)((IProject)element))) != null && javaProject.exists()) {
                this.project = javaProject;
            }
        }
    }

    public static void addDroolsBuilder(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if ("org.drools.eclipse.droolsbuilder".equals(commands[i].getBuilderName())) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand droolsCommand = description.newCommand();
        droolsCommand.setBuilderName("org.drools.eclipse.droolsbuilder");
        newCommands[commands.length] = droolsCommand;
        description.setBuildSpec(newCommands);
        project.getProject().setDescription(description, monitor);
    }

    public static void addDroolsLibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] classpathEntries = project.getRawClasspath();
        int i = 0;
        while (i < classpathEntries.length) {
            if (NewDroolsProjectWizard.DROOLS_CLASSPATH_CONTAINER_PATH.equals((Object)classpathEntries[i].getPath())) {
                return;
            }
            ++i;
        }
        NewDroolsProjectWizard.addDroolsLibraries(project, null);
    }
}

