/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.compiler.BaseKnowledgeBuilderResultImpl;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.FactTemplateError;
import org.drools.compiler.compiler.FieldTemplateError;
import org.drools.compiler.compiler.FunctionError;
import org.drools.compiler.compiler.GlobalError;
import org.drools.compiler.compiler.ImportError;
import org.drools.compiler.compiler.ParserError;
import org.drools.compiler.compiler.RuleBuildError;
import org.drools.compiler.lang.ExpanderException;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.builder.DroolsBuildMarker;
import org.drools.eclipse.builder.ResourceDescr;
import org.drools.eclipse.builder.Util;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.eclipse.wizard.project.NewDroolsProjectWizard;
import org.drools.template.parser.DecisionTableParseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.io.ResourceType;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.io.ResourceFactory;

public class DroolsBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.drools.eclipse.droolsbuilder";
    private boolean isKieProject = false;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return new IProject[0];
        }
        try {
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (CoreException e) {
            IMarker marker = currentProject.createMarker("org.drools.eclipse.problem");
            marker.setAttribute("message", (Object)("Error when trying to build Drools project: " + e.getLocalizedMessage()));
            marker.setAttribute("severity", 2);
        }
        return this.getRequiredProjects(currentProject);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.removeProblemsFor((IResource)this.getProject());
        IJavaProject project = JavaCore.create((IProject)this.getProject());
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader newLoader = ProjectClassLoader.getProjectClassLoader(project);
        try {
            Thread.currentThread().setContextClassLoader(newLoader);
            IClasspathEntry[] classpathEntries = project.getRawClasspath();
            int i = 0;
            while (i < classpathEntries.length) {
                String[] jars;
                if (NewDroolsProjectWizard.DROOLS_CLASSPATH_CONTAINER_PATH.equals((Object)classpathEntries[i].getPath().toString()) && ((jars = DroolsRuntimeManager.getDefault().getRuntimeJars(this.getProject())) == null || jars.length == 0)) {
                    IRuntime runtime = DroolsRuntimeManager.getDefault().getRuntime(this.getProject());
                    IMarker marker = this.getProject().createMarker("org.drools.eclipse.problem");
                    if (runtime == null) {
                        marker.setAttribute("message", (Object)"Could not find default Drools runtime");
                    } else {
                        marker.setAttribute("message", (Object)("Could not find Drools runtime " + runtime));
                    }
                    marker.setAttribute("severity", 2);
                    return;
                }
                ++i;
            }
            this.isKieProject = false;
            DroolsBuilderVisitor droolsBuilderVisitor = new DroolsBuilderVisitor();
            this.getProject().accept((IResourceVisitor)droolsBuilderVisitor);
            droolsBuilderVisitor.build();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        boolean fullBuild;
        IPreferenceStore store = DroolsEclipsePlugin.getDefault().getPreferenceStore();
        boolean bl = fullBuild = store.getBoolean("Drools.CrossBuild") || store.getBoolean("Drools.BuildAll") || this.isKieProject;
        if (!fullBuild) {
            fullBuild = DroolsEclipsePlugin.getDefault().resetForceFullBuild();
        }
        if (fullBuild) {
            this.fullBuild(monitor);
        } else {
            delta.accept((IResourceDeltaVisitor)new DroolsBuildDeltaVisitor());
        }
    }

    private boolean isInOutputDirectory(IResource res) throws JavaModelException {
        IJavaProject project = JavaCore.create((IProject)res.getProject());
        return !project.getOutputLocation().equals((Object)project.getPath()) && project.getOutputLocation().isPrefixOf(res.getFullPath());
    }

    private boolean exists(IResource res) {
        if (!res.exists()) {
            this.removeProblemsFor(res);
            DroolsEclipsePlugin.getDefault().invalidateResource(res);
            return false;
        }
        return true;
    }

    protected boolean parseResource(IResource res, boolean clean) {
        block26: {
            try {
                if (!".guvnorinfo".equals(res.getName())) break block26;
                return false;
            }
            catch (JavaModelException javaModelException) {}
        }
        if (this.isInOutputDirectory(res)) {
            return false;
        }
        if (!this.exists(res)) {
            return false;
        }
        if (res instanceof IFile) {
            String fileExtension = res.getFileExtension();
            if ("drl".equals(fileExtension) || "gdrl".equals(fileExtension) || "rdrl".equals(fileExtension) || "dslr".equals(fileExtension) || "rdslr".equals(fileExtension) || ".package".equals(res.getName())) {
                this.removeProblemsFor(res);
                try {
                    if (clean) {
                        DroolsEclipsePlugin.getDefault().invalidateResource(res);
                    }
                    this.appendMarkers(res, this.parseDRLFile((IFile)res));
                }
                catch (Throwable t) {
                    DroolsEclipsePlugin.log(t);
                    this.createMarker(res, t.getMessage(), -1);
                }
                return false;
            }
            if ("xls".equals(fileExtension)) {
                this.removeProblemsFor(res);
                try {
                    if (clean) {
                        DroolsEclipsePlugin.getDefault().invalidateResource(res);
                    }
                    this.appendMarkers(res, this.parseXLSFile((IFile)res));
                }
                catch (Throwable t) {
                    this.createMarker(res, t.getMessage(), -1);
                }
                return false;
            }
            if ("csv".equals(fileExtension)) {
                this.removeProblemsFor(res);
                try {
                    if (clean) {
                        DroolsEclipsePlugin.getDefault().invalidateResource(res);
                    }
                    this.appendMarkers(res, this.parseCSVFile((IFile)res));
                }
                catch (Throwable t) {
                    this.createMarker(res, t.getMessage(), -1);
                }
                return false;
            }
            if ("rf".equals(fileExtension)) {
                this.removeProblemsFor(res);
                try {
                    if (clean) {
                        DroolsEclipsePlugin.getDefault().invalidateResource(res);
                    }
                    this.appendMarkers(res, this.parseRuleFlowFile((IFile)res));
                }
                catch (Throwable t) {
                    this.createMarker(res, t.getMessage(), -1);
                }
                return false;
            }
            if ("bpmn".equals(fileExtension) || "bpmn2".equals(fileExtension)) {
                this.removeProblemsFor(res);
                try {
                    if (clean) {
                        DroolsEclipsePlugin.getDefault().invalidateResource(res);
                    }
                    this.appendMarkers(res, this.parseRuleFlowFile((IFile)res));
                }
                catch (Throwable t) {
                    this.createMarker(res, t.getMessage(), -1);
                }
                return false;
            }
        }
        return true;
    }

    private void appendMarkers(DRLInfo drlInfo) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        this.markParseErrors(markers, drlInfo.getParserErrors());
        this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        this.appendMarkers(drlInfo.getResource(), markers);
    }

    private void appendMarkers(IResource res, List<DroolsBuildMarker> markers) {
        for (DroolsBuildMarker marker : markers) {
            this.createMarker(res, marker.getText(), marker.getLine());
        }
    }

    private List<DroolsBuildMarker> parseResource(ResourceParser resourceParser) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        try {
            DRLInfo drlInfo = resourceParser.parseResource();
            this.markParseErrors(markers, drlInfo.getParserErrors());
            this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        }
        catch (DroolsParserException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException recogErr = (RecognitionException)cause;
                markers.add(new DroolsBuildMarker(recogErr.getMessage(), recogErr.line));
            }
        }
        catch (DecisionTableParseException e) {
            if (!"No RuleTable's were found in spreadsheet.".equals(e.getMessage())) {
                throw e;
            }
        }
        catch (Exception t) {
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers;
    }

    private List<DroolsBuildMarker> parseDRLFile(final IFile file) {
        return this.parseResource(new ResourceParser(){

            @Override
            public DRLInfo parseResource() throws DroolsParserException {
                return DroolsEclipsePlugin.getDefault().parseResource((IResource)file, true);
            }
        });
    }

    private List<DroolsBuildMarker> parseXLSFile(final IFile file) {
        return this.parseResource(new ResourceParser(){

            @Override
            public DRLInfo parseResource() throws DroolsParserException, DecisionTableParseException, CoreException {
                SpreadsheetCompiler converter = new SpreadsheetCompiler();
                String drl = converter.compile(file.getContents(), InputType.XLS);
                return DroolsEclipsePlugin.getDefault().parseXLSResource(drl, (IResource)file);
            }
        });
    }

    private List<DroolsBuildMarker> parseCSVFile(final IFile file) {
        return this.parseResource(new ResourceParser(){

            @Override
            public DRLInfo parseResource() throws DroolsParserException, CoreException {
                SpreadsheetCompiler converter = new SpreadsheetCompiler();
                String drl = converter.compile(file.getContents(), InputType.CSV);
                return DroolsEclipsePlugin.getDefault().parseXLSResource(drl, (IResource)file);
            }
        });
    }

    protected List<DroolsBuildMarker> parseRuleFlowFile(IFile file) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        if (!file.exists()) {
            return markers;
        }
        try {
            String input = DroolsBuilder.convertToString(file.getContents());
            ProcessInfo processInfo = DroolsEclipsePlugin.getDefault().parseProcess(input, (IResource)file);
            if (processInfo != null) {
                this.markParseErrors(markers, processInfo.getErrors());
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers;
    }

    protected static String convertToString(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    protected void markParseErrors(List<DroolsBuildMarker> markers, List<BaseKnowledgeBuilderResultImpl> parserErrors) {
        for (BaseKnowledgeBuilderResultImpl error : parserErrors) {
            if (error instanceof ParserError) {
                ParserError err = (ParserError)error;
                markers.add(new DroolsBuildMarker(err.getMessage(), err.getRow()));
                continue;
            }
            if (error instanceof KnowledgeBuilderResult) {
                KnowledgeBuilderResult res = (KnowledgeBuilderResult)error;
                int[] errorLines = res.getLines();
                markers.add(new DroolsBuildMarker(res.getMessage(), errorLines != null && errorLines.length > 0 ? errorLines[0] : -1));
                continue;
            }
            if (error instanceof ExpanderException) {
                ExpanderException exc = (ExpanderException)error;
                markers.add(new DroolsBuildMarker(exc.getMessage(), -1));
                continue;
            }
            markers.add(new DroolsBuildMarker(error.toString()));
        }
    }

    private void markOtherErrors(List<DroolsBuildMarker> markers, DroolsError[] buildErrors) {
        int i = 0;
        while (i < buildErrors.length) {
            int j;
            CompilationProblem[] problems;
            DroolsError error = buildErrors[i];
            if (error instanceof GlobalError) {
                GlobalError globalError = (GlobalError)error;
                markers.add(new DroolsBuildMarker("Global error: " + globalError.getGlobal(), -1));
            } else if (error instanceof RuleBuildError) {
                RuleBuildError ruleError = (RuleBuildError)error;
                if (ruleError.getObject() instanceof CompilationProblem[]) {
                    problems = (CompilationProblem[])ruleError.getObject();
                    j = 0;
                    while (j < problems.length) {
                        markers.add(new DroolsBuildMarker(problems[j].getMessage(), ruleError.getLine()));
                        ++j;
                    }
                } else {
                    markers.add(new DroolsBuildMarker(String.valueOf(ruleError.getRule().getName()) + ":" + ruleError.getMessage(), ruleError.getLine()));
                }
            } else if (error instanceof ParserError) {
                ParserError parserError = (ParserError)error;
                markers.add(new DroolsBuildMarker(parserError.getMessage(), parserError.getRow()));
            } else if (error instanceof FunctionError) {
                FunctionError functionError = (FunctionError)error;
                if (functionError.getObject() instanceof CompilationProblem[]) {
                    problems = (CompilationProblem[])functionError.getObject();
                    j = 0;
                    while (j < problems.length) {
                        markers.add(new DroolsBuildMarker(problems[j].getMessage(), functionError.getLines()[j]));
                        ++j;
                    }
                } else {
                    markers.add(new DroolsBuildMarker(String.valueOf(functionError.getFunctionDescr().getName()) + ":" + functionError.getMessage(), -1));
                }
            } else if (error instanceof FieldTemplateError) {
                markers.add(new DroolsBuildMarker(error.getMessage(), ((FieldTemplateError)error).getLine()));
            } else if (error instanceof FactTemplateError) {
                markers.add(new DroolsBuildMarker(error.getMessage(), ((FactTemplateError)error).getLine()));
            } else if (error instanceof ImportError) {
                markers.add(new DroolsBuildMarker("ImportError: " + error.getMessage()));
            } else if (error instanceof DescrBuildError) {
                markers.add(new DroolsBuildMarker("BuildError: " + error.getMessage(), ((DescrBuildError)error).getLine()));
            } else {
                markers.add(new DroolsBuildMarker("Unknown DroolsError " + error.getClass() + ": " + error));
            }
            ++i;
        }
    }

    protected void createMarker(final IResource res, final String message, final int lineNumber) {
        try {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker = res.createMarker("org.drools.eclipse.problem");
                    marker.setAttribute("message", (Object)message);
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("lineNumber", lineNumber);
                }
            };
            res.getWorkspace().run(r, null, 1, null);
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    protected void removeProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.drools.eclipse.problem", false, 2);
            }
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    private IProject[] getRequiredProjects(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IProject p;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && (p = project.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())) != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    private class DroolsBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        private DroolsBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            return DroolsBuilder.this.parseResource(delta.getResource(), false);
        }
    }

    private class DroolsBuilderVisitor
    implements IResourceVisitor {
        private final List<IResource> resources = new ArrayList<IResource>();

        private DroolsBuilderVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (DroolsBuilder.this.isInOutputDirectory(resource) || !DroolsBuilder.this.exists(resource)) {
                return false;
            }
            if (resource instanceof IFile) {
                DroolsBuilder droolsBuilder = DroolsBuilder.this;
                droolsBuilder.isKieProject = droolsBuilder.isKieProject | resource.getProjectRelativePath().toString().endsWith("META-INF/kmodule.xml");
                this.resources.add(resource);
            }
            return true;
        }

        public void build() throws CoreException {
            if (DroolsBuilder.this.isKieProject) {
                this.doBuildKieProject();
            } else if (DroolsEclipsePlugin.getDefault().getPreferenceStore().getBoolean("Drools.CrossBuild")) {
                this.doBatchBuild();
            } else {
                this.doBuild();
            }
        }

        private void doBuildKieProject() throws CoreException {
            KieServices ks = KieServices.Factory.get();
            KieFileSystem kfs = ks.newKieFileSystem();
            HashMap<String, IResource> resourcesMap = new HashMap<String, IResource>();
            for (IResource resource : this.resources) {
                String resourcePath = resource.getProjectRelativePath().toString();
                if (ResourceType.determineResourceType((String)resource.getName()) != null) {
                    DroolsBuilder.this.removeProblemsFor(resource);
                    kfs.write(resourcePath, ResourceFactory.newInputStreamResource((InputStream)((IFile)resource).getContents()));
                    resourcesMap.put(resourcePath, resource);
                    continue;
                }
                if (!resourcePath.endsWith("META-INF/kmodule.xml")) continue;
                kfs.writeKModuleXML(new String(Util.getResourceContentsAsCharArray((IFile)resource)));
            }
            KieBuilder kieBuilder = ks.newKieBuilder(kfs);
            List messages = kieBuilder.buildAll().getResults().getMessages();
            for (Message message : messages) {
                IResource resource = (IResource)resourcesMap.get(message.getPath());
                if (resource == null) {
                    resource = (IResource)resourcesMap.get("src/main/resources/" + message.getPath());
                }
                if (resource == null || resource.getName().endsWith(".java")) continue;
                DroolsBuilder.this.createMarker(resource, message.getText(), message.getLine());
            }
        }

        private void doBuild() {
            for (IResource resource : this.resources) {
                DroolsBuilder.this.parseResource(resource, true);
            }
        }

        private void doBatchBuild() {
            ArrayList<ResourceDescr> resourceDescrs = new ArrayList<ResourceDescr>();
            for (IResource resource : this.resources) {
                ResourceDescr resourceDescr = ResourceDescr.createResourceDescr(resource);
                if (resourceDescr == null) continue;
                DroolsBuilder.this.removeProblemsFor(resource);
                DroolsEclipsePlugin.getDefault().invalidateResource(resource);
                resourceDescrs.add(resourceDescr);
            }
            List<DRLInfo> drlInfos = DroolsEclipsePlugin.getDefault().parseResources(resourceDescrs);
            for (DRLInfo drlInfo : drlInfos) {
                DroolsBuilder.this.appendMarkers(drlInfo);
            }
        }
    }

    private static interface ResourceParser {
        public DRLInfo parseResource() throws DroolsParserException, DecisionTableParseException, CoreException, IOException;
    }
}

