/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsClasspathContainer;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.wizard.project.AbstractKieEmptyProjectWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieOnlineExampleProjectWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectStartWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectWizard;
import org.kie.eclipse.wizard.project.IKieProjectWizardPage;
import org.kie.eclipse.wizard.project.IKieSampleFilesProjectWizardPage;

public class NewDroolsProjectWizard
extends AbstractKieProjectWizard {
    public static final IPath DROOLS_CLASSPATH_CONTAINER_PATH = new Path("DROOLS/Drools");
    private EmptyDroolsProjectWizardPage emptyProjectPage;
    private SampleDroolsProjectWizardPage sampleFilesProjectPage;

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = DroolsEclipsePlugin.getImageDescriptor("icons/drools-large.PNG");
        this.setDefaultPageImageDescriptor(desc);
    }

    protected void createOutputLocation(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IFolder folder = this.createFolder(project, "target", monitor);
        IPath path = folder.getFullPath();
        project.setOutputLocation(path, null);
    }

    protected void addBuilders(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        super.addBuilders(project, monitor);
        this.addDroolsBuilder(project, monitor);
    }

    private void addDroolsBuilder(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand droolsCommand = description.newCommand();
        droolsCommand.setBuilderName("org.drools.eclipse.droolsbuilder");
        newCommands[commands.length] = droolsCommand;
        description.setBuildSpec(newCommands);
        project.getProject().setDescription(description, monitor);
    }

    protected IClasspathContainer createClasspathContainer(IJavaProject project, IProgressMonitor monitor) {
        return new DroolsClasspathContainer(project, DROOLS_CLASSPATH_CONTAINER_PATH);
    }

    private static void createDroolsLibraryContainer(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        JavaCore.setClasspathContainer((IPath)DROOLS_CLASSPATH_CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{new DroolsClasspathContainer(project, DROOLS_CLASSPATH_CONTAINER_PATH)}, (IProgressMonitor)monitor);
    }

    public static void addDroolsLibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        NewDroolsProjectWizard.createDroolsLibraryContainer(project, monitor);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.add(JavaCore.newContainerEntry((IPath)DROOLS_CLASSPATH_CONTAINER_PATH));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    protected void createInitialContent(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException, JavaModelException, IOException {
        if (this.startPage.getInitialProjectContent() == 2) {
            if (this.sampleFilesProjectPage.shouldCreateJavaRuleFile()) {
                this.createRuleSampleLauncher(javaProject);
            }
            if (this.sampleFilesProjectPage.shouldCreateRuleFile()) {
                this.createRule(javaProject, monitor);
            }
            if (this.sampleFilesProjectPage.shouldCreateDecisionTableFile()) {
                this.createDecisionTable(javaProject, monitor);
            }
            if (this.sampleFilesProjectPage.shouldCreateJavaDecisionTableFile()) {
                this.createDecisionTableSampleLauncher(javaProject);
            }
            if (this.sampleFilesProjectPage.shouldCreateRuleFlowFile()) {
                this.createRuleFlow(javaProject, monitor);
            }
            if (this.sampleFilesProjectPage.shouldCreateJavaRuleFlowFile()) {
                this.createRuleFlowSampleLauncher(javaProject);
            }
        }
        super.createInitialContent(javaProject, monitor);
    }

    protected void createMavenArtifacts(IJavaProject project, IProgressMonitor monitor) {
        try {
            String projectName = project.getProject().getName();
            String groupId = String.valueOf(projectName) + ".group";
            String artifactId = String.valueOf(projectName) + ".artifact";
            String version = "1.0";
            this.createProjectFile(project, monitor, this.generatePomProperties(groupId, artifactId, version), "src/main/resources/META-INF/maven", "pom.properties");
            this.createProjectFile(project, monitor, this.generatePom(groupId, artifactId, version), null, "pom.xml");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void createKJarArtifacts(IJavaProject project, IProgressMonitor monitor) {
        try {
            if (this.startPage.getRuntime().getVersion().startsWith("6")) {
                this.createProjectFile(project, monitor, this.generateKModule(), "src/main/resources/META-INF", "kmodule.xml");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private InputStream generateKModule() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kmodule xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n");
        if (this.sampleFilesProjectPage.shouldCreateRuleFile() || this.sampleFilesProjectPage.shouldCreateJavaRuleFile()) {
            sb.append("    <kbase name=\"rules\" packages=\"rules\">\n");
            sb.append("        <ksession name=\"ksession-rules\"/>\n");
            sb.append("    </kbase>\n");
        }
        if (this.sampleFilesProjectPage.shouldCreateDecisionTableFile() || this.sampleFilesProjectPage.shouldCreateJavaDecisionTableFile()) {
            sb.append("    <kbase name=\"dtables\" packages=\"dtables\">\n");
            sb.append("        <ksession name=\"ksession-dtables\"/>\n");
            sb.append("    </kbase>\n");
        }
        if (this.sampleFilesProjectPage.shouldCreateRuleFlowFile() || this.sampleFilesProjectPage.shouldCreateJavaRuleFlowFile()) {
            sb.append("    <kbase name=\"process\" packages=\"process\">\n");
            sb.append("        <ksession name=\"ksession-process\"/>\n");
            sb.append("    </kbase>\n");
        }
        sb.append("</kmodule>\n");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private InputStream generatePom(String groupId, String artifactId, String version) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + groupId + "</groupId>\n" + "  <artifactId>" + artifactId + "</artifactId>\n" + "  <version>" + version + "</version>\n" + "</project>\n";
        return new ByteArrayInputStream(pom.getBytes());
    }

    private InputStream generatePomProperties(String groupId, String artifactId, String version) {
        String pom = "groupId=" + groupId + "\n" + "artifactId=" + artifactId + "\n" + "version=" + version + "\n";
        return new ByteArrayInputStream(pom.getBytes());
    }

    private void createRuleSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        String version = this.startPage.getRuntime().getVersion();
        if (version.startsWith("4")) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_4.java.template", "DroolsTest.java");
        } else if (version.startsWith("5")) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_5.java.template", "DroolsTest.java");
        } else if (version.startsWith("6")) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_6.java.template", "DroolsTest.java");
        }
    }

    private void createDecisionTableSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        String version = this.startPage.getRuntime().getVersion();
        if (version.startsWith("4")) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_4.java.template", "DecisionTableTest.java");
        } else if (version.startsWith("5")) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_5.java.template", "DecisionTableTest.java");
        } else if (version.startsWith("6")) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_6.java.template", "DecisionTableTest.java");
        }
    }

    private void createProjectJavaFile(IJavaProject project, String templateFile, String javaFile) throws JavaModelException, IOException {
        IFolder folder = project.getProject().getFolder("src/main/java");
        IPackageFragmentRoot packageFragmentRoot = project.getPackageFragmentRoot((IResource)folder);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment("com.sample", true, null);
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(templateFile);
        packageFragment.createCompilationUnit(javaFile, new String(this.readStream(inputstream)), true, null);
    }

    private void createProjectFile(IJavaProject project, IProgressMonitor monitor, String templateFile, String folderName, String fileName) throws CoreException {
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(templateFile);
        this.createProjectFile(project, monitor, inputstream, folderName, fileName);
    }

    private void createProjectFile(IJavaProject project, IProgressMonitor monitor, InputStream inputstream, String folderName, String fileName) throws CoreException {
        IFile file;
        if (folderName == null) {
            file = project.getProject().getFile(fileName);
        } else {
            IFolder folder = project.getProject().getFolder(folderName);
            file = folder.getFile(fileName);
        }
        if (!file.exists()) {
            file.create(inputstream, true, monitor);
        } else {
            file.setContents(inputstream, true, false, monitor);
        }
    }

    private void createRule(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (this.startPage.getRuntime().getVersion().startsWith("6")) {
            this.createFolder(project, "src/main/resources/rules", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.drl.template", "src/main/resources/rules", "Sample.drl");
        } else {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.drl.template", "src/main/rules", "Sample.drl");
        }
    }

    private void createDecisionTable(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (this.startPage.getRuntime().getVersion().startsWith("6")) {
            this.createFolder(project, "src/main/resources/dtables", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.xls.template", "src/main/resources/dtables", "Sample.xls");
        } else {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.xls.template", "src/main/rules", "Sample.xls");
        }
    }

    private void createRuleFlow(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        String version = this.startPage.getRuntime().getVersion();
        if (version.startsWith("4")) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.rf.template", "src/main/rules", "ruleflow.rf");
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.rfm.template", "src/main/rules", "ruleflow.rfm");
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.drl.template", "src/main/rules", "ruleflow.drl");
        } else if (version.startsWith("5.1")) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/sample.bpmn.template", "src/main/rules", "sample.bpmn");
        } else if (version.startsWith("5")) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow.rf.template", "src/main/rules", "ruleflow.rf");
        } else {
            this.createFolder(project, "src/main/resources/process", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/sample.bpmn.template", "src/main/resources/process", "sample.bpmn");
        }
    }

    private void createRuleFlowSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        String version = this.startPage.getRuntime().getVersion();
        String s = version.startsWith("4") ? "org/drools/eclipse/wizard/project/RuleFlowLauncherSample_4.java.template" : (version.startsWith("5.1") ? "org/drools/eclipse/wizard/project/ProcessLauncherSample_bpmn_5.java.template" : (version.startsWith("5") ? "org/drools/eclipse/wizard/project/RuleFlowLauncherSample.java.template" : "org/drools/eclipse/wizard/project/ProcessLauncherSample_bpmn_6.java.template"));
        this.createProjectJavaFile(project, s, "ProcessTest.java");
    }

    protected IKieProjectWizardPage createStartPage(String pageId) {
        return new AbstractKieProjectStartWizardPage(pageId){

            public String getTitle() {
                return "Create New Drools Project";
            }
        };
    }

    protected IKieProjectWizardPage createEmptyProjectPage(String pageId) {
        this.emptyProjectPage = new EmptyDroolsProjectWizardPage("NewEmptProjectPage");
        return this.emptyProjectPage;
    }

    protected IKieProjectWizardPage createSampleFilesProjectPage(String pageId) {
        this.sampleFilesProjectPage = new SampleDroolsProjectWizardPage("NewSampleFilesProjectPage");
        return this.sampleFilesProjectPage;
    }

    protected IKieProjectWizardPage createOnlineExampleProjectPage(String pageId) {
        return new AbstractKieOnlineExampleProjectWizardPage("NewOnlineExampleProjectPage"){

            public String getTitle() {
                return "Create Drools Projects from Online Examples";
            }

            public String getDescription() {
                return "Select Drools Example Projects";
            }

            public String getProductId() {
                return "drools";
            }
        };
    }

    class EmptyDroolsProjectWizardPage
    extends AbstractKieEmptyProjectWizardPage
    implements IKieSampleFilesProjectWizardPage {
        public EmptyDroolsProjectWizardPage(String pageName) {
            super(pageName);
            this.setTitle("Create New Empty Drools Project");
            this.setDescription("Select the type of Drools Project");
        }

        protected void createControls(Composite parent) {
        }

        public IRuntimeManager getRuntimeManager() {
            return DroolsRuntimeManager.getDefault();
        }

        protected IRuntime createRuntime() {
            return new DroolsRuntime();
        }

        public int showRuntimePreferenceDialog() {
            return PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.drools.eclipse.preferences.DroolsRuntimesPreferencePage", (String[])new String[]{"org.drools.eclipse.preferences.DroolsProjectPreferencePage"}, null).open();
        }
    }

    class SampleDroolsProjectWizardPage
    extends EmptyDroolsProjectWizardPage {
        private boolean addSampleRule;
        private boolean addSampleJavaRuleCode;
        private boolean addSampleDecisionTableCode;
        private boolean addSampleJavaDecisionTableCode;
        private boolean addSampleRuleFlow;
        private boolean addSampleJavaRuleFlowCode;

        public SampleDroolsProjectWizardPage(String pageName) {
            super(pageName);
            this.addSampleRule = true;
            this.addSampleJavaRuleCode = false;
            this.addSampleDecisionTableCode = true;
            this.addSampleJavaDecisionTableCode = false;
            this.addSampleRuleFlow = true;
            this.addSampleJavaRuleFlowCode = false;
            this.setTitle("Create New Drools Projects with Sample Files");
            this.setDescription("Select the sample files to be included");
        }

        protected Composite createKJarControls(Composite parent) {
            return null;
        }

        @Override
        protected void createControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            GridData gd = new GridData(768);
            gd.verticalIndent = 10;
            gd.horizontalIndent = 10;
            composite.setLayoutData((Object)gd);
            composite.setLayoutData((Object)gd);
            Button addSampleRuleButton = this.createCheckBox(composite, "Add a sample HelloWorld rule file to this project.");
            addSampleRuleButton.setSelection(this.addSampleRule);
            addSampleRuleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SampleDroolsProjectWizardPage.this.addSampleRule = ((Button)e.widget).getSelection();
                }
            });
            Button addSampleDecisionTableCodeButton = this.createCheckBox(composite, "Add a sample HelloWorld decision table file to this project.");
            addSampleDecisionTableCodeButton.setSelection(this.addSampleDecisionTableCode);
            addSampleDecisionTableCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SampleDroolsProjectWizardPage.this.addSampleDecisionTableCode = ((Button)e.widget).getSelection();
                }
            });
            Button addSampleRuleFlowButton = this.createCheckBox(composite, "Add a sample HelloWorld process file to this project.");
            addSampleRuleFlowButton.setSelection(this.addSampleRuleFlow);
            addSampleRuleFlowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SampleDroolsProjectWizardPage.this.addSampleRuleFlow = ((Button)e.widget).getSelection();
                }
            });
        }

        private Button createCheckBox(Composite group, String label) {
            Button button = new Button(group, 16416);
            button.setText(label);
            GridData data = new GridData();
            button.setLayoutData((Object)data);
            return button;
        }

        private Button createCheckBox2(final Button dependent, Composite group, String label) {
            Button button = new Button(group, 16416);
            button.setText(label);
            GridData data = new GridData();
            data.horizontalIndent = 20;
            button.setLayoutData((Object)data);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ((Button)e.widget).getSelection();
                    if (selected) {
                        dependent.setSelection(true);
                        dependent.setEnabled(false);
                    } else {
                        dependent.setEnabled(true);
                    }
                }
            });
            return button;
        }

        public boolean shouldCreateRuleFile() {
            return this.addSampleRule;
        }

        public boolean shouldCreateJavaRuleFile() {
            return this.addSampleRule;
        }

        public boolean shouldCreateDecisionTableFile() {
            return this.addSampleDecisionTableCode;
        }

        public boolean shouldCreateJavaDecisionTableFile() {
            return this.addSampleDecisionTableCode;
        }

        public boolean shouldCreateRuleFlowFile() {
            return this.addSampleRuleFlow;
        }

        public boolean shouldCreateJavaRuleFlowFile() {
            return this.addSampleRuleFlow;
        }
    }
}

