/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.core.process.core.datatype.DataType;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.completion.RuleCompletionProcessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.WorkflowProcess;

public class ConstraintCompletionProcessor
extends RuleCompletionProcessor {
    private WorkflowProcess process;
    private List<String> imports;
    private List<GlobalDescr> globals;
    private String type;

    public ConstraintCompletionProcessor(WorkflowProcess process) {
        super((AbstractRuleEditor)null);
        this.process = process;
    }

    @Override
    public IEditorPart getEditor() {
        IWorkbenchPage workbenchPage;
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (workbenchPage = workbenchWindow.getActivePage()) != null) {
            return workbenchPage.getActiveEditor();
        }
        return null;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected String readBackwards(int documentOffset, IDocument doc) throws BadLocationException {
        int startPart = doc.getPartition(documentOffset).getOffset();
        String prefix = doc.get(startPart, documentOffset - startPart);
        if ("code".equals(this.type)) {
            if (prefix.startsWith("return ")) {
                prefix = prefix.substring(7);
            }
            String result = "rule dummy when eval( ";
            VariableScope variableScope = (VariableScope)this.process.getDefaultContext("VariableScope");
            if (variableScope != null) {
                for (Variable variable : variableScope.getVariables()) {
                    DataType type = variable.getType();
                    result = String.valueOf(result) + type.getStringType() + " " + variable.getName() + "; ";
                }
            }
            return String.valueOf(result) + prefix;
        }
        return "rule dummy \n when \n" + prefix;
    }

    @Override
    public List<String> getImports() {
        if (this.imports == null) {
            this.loadImports();
        }
        return this.imports;
    }

    private void loadImports() {
        this.imports = new ArrayList<String>();
        Set imports = this.process.getImports();
        if (imports != null) {
            for (String importName : imports) {
                if (importName.endsWith(".*")) {
                    IJavaProject javaProject = this.getJavaProject();
                    if (javaProject == null) continue;
                    String packageName = importName.substring(0, importName.length() - 2);
                    this.imports.addAll(DRLRuleEditor.getAllClassesInPackage(packageName, javaProject));
                    continue;
                }
                this.imports.add(importName);
            }
        }
    }

    @Override
    public List<GlobalDescr> getGlobals() {
        if (this.globals == null) {
            this.loadGlobals();
        }
        return this.globals;
    }

    private void loadGlobals() {
        String[] globalNames = this.process.getGlobalNames();
        this.globals = new ArrayList<GlobalDescr>(globalNames.length);
        String[] stringArray = globalNames;
        int n = globalNames.length;
        int n2 = 0;
        while (n2 < n) {
            String globalName = stringArray[n2];
            this.globals.add(new GlobalDescr(globalName, "java.lang.Object"));
            ++n2;
        }
    }

    private IJavaProject getJavaProject() {
        IEditorPart editor = this.getEditor();
        if (editor != null && editor.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
            try {
                if (file.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
                    return JavaCore.create((IProject)file.getProject());
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void reset() {
        this.imports = null;
        this.globals = null;
    }
}

