/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart.work;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.WorkDefinition;
import org.drools.core.process.core.WorkEditor;
import org.drools.core.process.core.impl.WorkImpl;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EmailCustomEditor
extends EditBeanDialog<Work>
implements WorkEditor {
    private List<Recipient> recipients = new ArrayList<Recipient>();
    private Text fromText;
    private Text subjectText;
    private Text bodyText;

    public EmailCustomEditor(Shell parentShell) {
        super(parentShell, "Custom Work Editor");
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        Work work = (Work)this.getValue();
        String from = (String)work.getParameter("From");
        String to = (String)work.getParameter("To");
        String body = (String)work.getParameter("Body");
        String subject = (String)work.getParameter("Subject");
        if (to != null) {
            String[] stringArray = to.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String email = stringArray[n2];
                if (!"".equals(email)) {
                    Recipient recipient = new Recipient();
                    recipient.setEmail(email);
                    this.recipients.add(recipient);
                }
                ++n2;
            }
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(composite, 0);
        this.createHeadersTab(tabFolder);
        this.createBodyTab(tabFolder);
        if (from != null) {
            this.fromText.setText(from);
        }
        if (subject != null) {
            this.subjectText.setText(subject);
        }
        if (body != null) {
            this.bodyText.setText(body);
        }
        return composite;
    }

    public void createHeadersTab(TabFolder tabFolder) {
        TabItem headersTabItem = new TabItem(tabFolder, 0);
        headersTabItem.setText("Header");
        Composite container = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 2;
        container.setLayout((Layout)gridLayout);
        headersTabItem.setControl((Control)container);
        Label recipientsLabel = new Label(container, 0);
        GridData gd_recipientsLabel = new GridData();
        recipientsLabel.setLayoutData((Object)gd_recipientsLabel);
        recipientsLabel.setText("Recipients");
        new Label(container, 0);
        final TableViewer tableViewer = new TableViewer(container, 67584);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.setLabelProvider((CellLabelProvider)new EmailLabelProvider());
        column.setEditingSupport((EditingSupport)new EmailEditing(tableViewer));
        column.getColumn().setText("Email Address");
        column.getColumn().setWidth(200);
        column.getColumn().setMoveable(true);
        final Table table = tableViewer.getTable();
        GridData gd_table = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_table.heightHint = 128;
        table.setLayoutData((Object)gd_table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        tableViewer.setContentProvider((IContentProvider)new RecipientsContentProvider());
        tableViewer.setInput(this.recipients);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        composite.setLayout((Layout)new RowLayout());
        Button addButton = new Button(composite, 0);
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Recipient recipient = new Recipient();
                EmailCustomEditor.this.recipients.add(recipient);
                tableViewer.add((Object)recipient);
                tableViewer.refresh();
            }

            public void widgetSelected(SelectionEvent e) {
                Recipient recipient = new Recipient();
                EmailCustomEditor.this.recipients.add(recipient);
                tableViewer.add((Object)recipient);
                tableViewer.refresh();
            }
        });
        Button deleteButton = new Button(composite, 0);
        deleteButton.setText("Remove");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    EmailCustomEditor.this.recipients.remove((Recipient)items[0].getData());
                    tableViewer.remove((Object)items[0]);
                    tableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    EmailCustomEditor.this.recipients.remove((Recipient)items[0].getData());
                    tableViewer.remove((Object)items[0]);
                    tableViewer.refresh();
                }
            }
        });
        Label fromLabel = new Label(container, 0);
        fromLabel.setLayoutData((Object)new GridData());
        fromLabel.setText("From");
        this.fromText = new Text(container, 2048);
        this.fromText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void createBodyTab(TabFolder tabFolder) {
        TabItem headersTabItem = new TabItem(tabFolder, 0);
        headersTabItem.setText("Body");
        Composite container = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2;
        container.setLayout((Layout)gridLayout);
        headersTabItem.setControl((Control)container);
        Label subjectLabel = new Label(container, 0);
        subjectLabel.setLayoutData((Object)new GridData());
        subjectLabel.setText("Subject");
        this.subjectText = new Text(container, 2048);
        this.subjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label bodyLabel = new Label(container, 0);
        bodyLabel.setText("Body");
        this.bodyText = new Text(container, 2050);
        GridData gd_bodyText = new GridData(4, 0x1000000, true, false);
        gd_bodyText.heightHint = 175;
        this.bodyText.setLayoutData((Object)gd_bodyText);
    }

    @Override
    protected Work updateValue(Work value) {
        WorkImpl work = new WorkImpl();
        work.setName(value.getName());
        work.setParameter("From", (Object)this.fromText.getText());
        String to = "";
        int i = 0;
        while (i < this.recipients.size()) {
            to = String.valueOf(to) + this.recipients.get(i).getEmail();
            if (i != this.recipients.size() - 1) {
                to = String.valueOf(to) + ";";
            }
            ++i;
        }
        work.setParameter("To", (Object)to);
        work.setParameter("Subject", (Object)this.subjectText.getText());
        work.setParameter("Body", (Object)this.bodyText.getText());
        work.setParameterDefinitions(value.getParameterDefinitions());
        return work;
    }

    public Work getWork() {
        return (Work)this.getValue();
    }

    public void setWork(Work work) {
        this.setValue(work);
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
        if (!"Email".equals(workDefinition.getName())) {
            DroolsEclipsePlugin.log(new IllegalArgumentException("The emailCustomEditor can only handle email work items."));
        }
    }

    public boolean show() {
        int result = this.open();
        return result == 0;
    }

    private class DisplayNameEditing
    extends EditingSupport {
        private TextCellEditor cellEditor;

        public DisplayNameEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.cellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ((Recipient)element).getDisplayName();
        }

        protected void setValue(Object element, Object value) {
            ((Recipient)element).setDisplayName(value.toString());
            this.getViewer().update(element, null);
        }
    }

    private class DisplayNameLabelProvider
    extends ColumnLabelProvider {
        private DisplayNameLabelProvider() {
        }

        public String getText(Object element) {
            return ((Recipient)element).getDisplayName();
        }
    }

    private class EmailEditing
    extends EditingSupport {
        private TextCellEditor cellEditor;

        public EmailEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.cellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ((Recipient)element).getEmail();
        }

        protected void setValue(Object element, Object value) {
            ((Recipient)element).setEmail(value.toString());
            this.getViewer().update(element, null);
        }
    }

    private class EmailLabelProvider
    extends ColumnLabelProvider {
        private EmailLabelProvider() {
        }

        public String getText(Object element) {
            return ((Recipient)element).getEmail();
        }
    }

    private class Recipient {
        private String type = "to";
        private String displayName = "";
        private String email = "john.doe@mail.com";

        private Recipient() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }

    private class RecipientsContentProvider
    implements IStructuredContentProvider {
        private RecipientsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return EmailCustomEditor.this.recipients.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TypeEditing
    extends EditingSupport {
        private ComboBoxCellEditor cellEditor;
        private String[] values;

        public TypeEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.values = new String[]{"to", "cc", "bcc"};
            this.cellEditor = new ComboBoxCellEditor((Composite)viewer.getTable(), this.values);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            Recipient p = (Recipient)element;
            return new Integer(Arrays.binarySearch(this.values, p.getType()));
        }

        protected void setValue(Object element, Object value) {
            int i = (Integer)value;
            if (i != -1) {
                ((Recipient)element).setType(this.values[i]);
            }
            this.getViewer().update(element, null);
        }
    }

    private class TypeLabelProvider
    extends ColumnLabelProvider {
        private TypeLabelProvider() {
        }

        public String getText(Object element) {
            return ((Recipient)element).getType();
        }
    }
}

