/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    private static final ColorManager INSTANCE = new ColorManager();
    public static final RGB SINGLE_LINE_COMMENT = new RGB(128, 128, 0);
    public static final RGB KEYWORD = new RGB(150, 0, 0);
    public static final RGB STRING = new RGB(0, 128, 0);
    protected Map<RGB, Color> colorTable = new HashMap<RGB, Color>(10);

    void dispose() {
        Iterator<Color> e = this.colorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public static ColorManager getInstance() {
        return INSTANCE;
    }

    public Color getColor(RGB rgb) {
        Color color = this.colorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.colorTable.put(rgb, color);
        }
        return color;
    }
}

