/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.refactoring;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.refactoring.DRLProjectDetector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.kie.eclipse.utils.FileUtils;

public class RuleIFileRenameParticipant
extends RenameParticipant {
    public static final String NAME = "Rule File Rename Refactoring";
    private DRLProjectDetector drlProjectDetector = new DRLProjectDetector();
    private RefactoringProcessor processor;
    private List<IFile> drlFiles;
    private IFile file;
    private String newName;
    private String currentName;
    private String packageName;
    private String className;
    private Pattern classPattern;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.file == null || this.file.isReadOnly()) {
            status.addFatalError("File don't exists or is read only");
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange changes = new CompositeChange("Reorganize DRL " + this.currentName + " Type ");
        this.drlFiles = this.drlProjectDetector.detect(this.file.getProject());
        this.classPattern = Pattern.compile("(?<=\\W)" + this.currentName + "(?=\\W)");
        for (IFile drlFile : this.drlFiles) {
            TextFileChange change = this.createChangesForFile(drlFile);
            if (change == null || change.getEdit().getChildrenSize() <= 0) continue;
            changes.add((Change)change);
        }
        if (changes.getChildren().length == 0) {
            return null;
        }
        DroolsEclipsePlugin.getDefault().setForceFullBuild();
        return changes;
    }

    private TextFileChange createChangesForFile(IFile drlFile) throws CoreException {
        DRLInfo drlInfo = null;
        try {
            drlInfo = DroolsEclipsePlugin.getDefault().parseResource((IResource)drlFile, false);
        }
        catch (DroolsParserException droolsParserException) {}
        if (drlInfo == null) {
            return null;
        }
        String content = FileUtils.readFile((IFile)drlFile);
        if (content == null) {
            return null;
        }
        TextFileChange change = new TextFileChange(drlFile.getName(), drlFile);
        MultiTextEdit mte = new MultiTextEdit();
        change.setEdit((TextEdit)mte);
        boolean isImported = false;
        for (ImportDescr importDescr : drlInfo.getPackageDescr().getImports()) {
            isImported |= importDescr.getTarget().equals(this.className) || importDescr.getTarget().equals(String.valueOf(this.packageName) + ".*");
            this.addReplace(mte, importDescr.getTarget(), content, importDescr.getStartCharacter(), importDescr.getEndCharacter());
        }
        if (!isImported) {
            return change;
        }
        Object[] objectArray = drlInfo.getRuleInfos();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DRLInfo.RuleInfo ruleInfo = objectArray[n2];
            List<DRLInfo.PatternInfo> patternInfos = ruleInfo.getPatternInfos();
            if (patternInfos != null) {
                for (DRLInfo.PatternInfo patternInfo : patternInfos) {
                    this.addReplace(mte, patternInfo.getPatternTypeName(), content, patternInfo.getStart(), patternInfo.getEnd());
                }
                this.addReplace(mte, this.className, content, ruleInfo.getConsequenceStart(), ruleInfo.getConsequenceEnd());
            } else {
                this.addReplace(mte, this.className, content, ruleInfo.getRuleStart(), ruleInfo.getRuleEnd());
            }
            ++n2;
        }
        objectArray = drlInfo.getFunctionInfos();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object functionInfo = objectArray[n2];
            this.addReplace(mte, this.className, content, ((DRLInfo.FunctionInfo)functionInfo).getFunctionStart(), ((DRLInfo.FunctionInfo)functionInfo).getFunctionEnd());
            ++n2;
        }
        return change;
    }

    private void addReplace(MultiTextEdit mte, String descrClassName, String content, int start, int end) {
        if (this.className.equals(descrClassName)) {
            String text = content.substring(start - 1, end + 1);
            Matcher matcher = this.classPattern.matcher(text);
            while (matcher.find()) {
                mte.addChild((TextEdit)new ReplaceEdit(matcher.start() + start - 1, this.currentName.length(), this.newName));
            }
        }
    }

    public String getName() {
        return NAME;
    }

    protected boolean initialize(Object element) {
        IFile file;
        if (element instanceof IFile && (file = (IFile)element).getType() == 1 && file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("java")) {
            this.processor = this.getProcessor();
            this.file = file;
            if (this.processor instanceof JavaRenameProcessor) {
                JavaRenameProcessor javaProcessor = (JavaRenameProcessor)this.processor;
                this.newName = javaProcessor.getNewElementName().replace(".java", "");
                this.currentName = javaProcessor.getCurrentElementName();
                try {
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaProcessor.getElements()[0];
                    this.packageName = compilationUnit.getPackageDeclarations()[0].getElementName();
                    this.className = String.valueOf(this.packageName) + "." + this.currentName;
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

