/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;

public abstract class TransformedDocument
extends AbstractDocument {
    private IDocument parentDocument;
    private boolean changed = true;

    public TransformedDocument(IDocument parentDocument) {
        this.parentDocument = parentDocument;
        parentDocument.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                TransformedDocument.this.changed = true;
            }
        });
        this.setTextStore(new StringTextStore());
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
    }

    protected ITextStore getStore() {
        if (this.changed) {
            this.update();
        }
        return super.getStore();
    }

    private void update() {
        String translation = this.transformInput(this.parentDocument.get());
        super.getStore().set(translation);
        this.getTracker().set(translation);
        this.changed = false;
    }

    protected abstract String transformInput(String var1);

    private static class StringTextStore
    implements ITextStore {
        private String fContent;

        public char get(int offset) {
            return this.fContent.charAt(offset);
        }

        public String get(int offset, int length) {
            return this.fContent.substring(offset, offset + length);
        }

        public int getLength() {
            return this.fContent.length();
        }

        public void replace(int offset, int length, String text) {
        }

        public void set(String text) {
            this.fContent = text;
        }
    }
}

