/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.Stack;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public final class DroolsPairMatcher
implements ICharacterPairMatcher {
    private int anchor;
    private static final char[] leftChars = new char[]{'(', '{', '['};
    private static final char[] rightChars = new char[]{')', '}', ']'};

    public IRegion match(IDocument document, int offset) {
        if (offset <= 0) {
            return null;
        }
        try {
            char c = document.getChar(offset - 1);
            int i = 0;
            while (i < rightChars.length) {
                if (c == rightChars[i]) {
                    return this.searchLeft(document, offset, rightChars[i], leftChars[i]);
                }
                if (c == leftChars[i]) {
                    return this.searchRight(document, offset, rightChars[i], leftChars[i]);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            DroolsEclipsePlugin.log(e);
        }
        return null;
    }

    private IRegion searchRight(IDocument document, int offset, char rightChar, char leftChar) throws BadLocationException {
        Stack<Character> stack = new Stack<Character>();
        this.anchor = 1;
        char[] chars = document.get(offset, document.getLength() - offset).toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == leftChar) {
                stack.push(new Character(chars[i]));
            } else if (chars[i] == rightChar) {
                if (stack.isEmpty()) {
                    return new Region(offset - 1, i + 2);
                }
                stack.pop();
            }
            ++i;
        }
        return null;
    }

    private IRegion searchLeft(IDocument document, int offset, char rightChar, char leftChar) throws BadLocationException {
        Stack<Character> stack = new Stack<Character>();
        this.anchor = 0;
        char[] chars = document.get(0, offset - 1).toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            if (chars[i] == rightChar) {
                stack.push(new Character(chars[i]));
            } else if (chars[i] == leftChar) {
                if (stack.isEmpty()) {
                    return new Region(i, offset - i);
                }
                stack.pop();
            }
            --i;
        }
        return null;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void dispose() {
    }

    public void clear() {
    }
}

