/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.core.ui;

import org.drools.eclipse.core.ActivationGroup;
import org.drools.eclipse.core.AgendaGroup;
import org.drools.eclipse.core.DefaultRuleGroup;
import org.drools.eclipse.core.DroolsElement;
import org.drools.eclipse.core.Expander;
import org.drools.eclipse.core.Function;
import org.drools.eclipse.core.Global;
import org.drools.eclipse.core.Import;
import org.drools.eclipse.core.Package;
import org.drools.eclipse.core.Query;
import org.drools.eclipse.core.Rule;
import org.drools.eclipse.core.RuleAttribute;
import org.drools.eclipse.core.RuleFlowGroup;
import org.drools.eclipse.core.RuleSet;
import org.drools.eclipse.core.Template;
import org.drools.eclipse.core.ui.DroolsLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class DroolsTreeSorter
extends ViewerSorter {
    private static final int RULESET = 0;
    private static final int PACKAGE = 1;
    private static final int RULE = 2;
    private static final int QUERY = 3;
    private static final int FUNCTION = 4;
    private static final int TEMPLATE = 5;
    private static final int EXPANDER = 6;
    private static final int GLOBAL = 7;
    private static final int IMPORT = 8;
    private static final int DEFAULT_RULE_GROUP = 11;
    private static final int ACTIVATION_GROUP = 12;
    private static final int AGENDA_GROUP = 13;
    private static final int RULEFLOW_GROUP = 14;
    private static final int RULE_ATTRIBUTE = 9;
    private static final int UNKNOWN = 10;
    private static DroolsLabelProvider labelProvider = new DroolsLabelProvider();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int type2;
        DroolsElement node1 = (DroolsElement)e1;
        DroolsElement node2 = (DroolsElement)e2;
        int type1 = this.getElementType(node1);
        if (type1 != (type2 = this.getElementType(node2))) {
            return type1 - type2;
        }
        String label1 = labelProvider.getText(node1);
        String label2 = labelProvider.getText(node2);
        if (label1 == null) {
            return label2 == null ? 0 : -1;
        }
        return label1.compareTo(label2);
    }

    private int getElementType(DroolsElement o) {
        if (o instanceof RuleSet) {
            return 0;
        }
        if (o instanceof Package) {
            return 1;
        }
        if (o instanceof Rule) {
            return 2;
        }
        if (o instanceof Query) {
            return 3;
        }
        if (o instanceof Function) {
            return 4;
        }
        if (o instanceof Template) {
            return 5;
        }
        if (o instanceof Expander) {
            return 6;
        }
        if (o instanceof Global) {
            return 7;
        }
        if (o instanceof Import) {
            return 8;
        }
        if (o instanceof RuleAttribute) {
            return 9;
        }
        if (o instanceof RuleFlowGroup) {
            return 14;
        }
        if (o instanceof AgendaGroup) {
            return 13;
        }
        if (o instanceof ActivationGroup) {
            return 12;
        }
        if (o instanceof DefaultRuleGroup) {
            return 11;
        }
        return 10;
    }
}

