/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsClasspathContainer;
import org.drools.eclipse.util.DroolsRuntime;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.kie.eclipse.runtime.AbstractRuntimeManager;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeRecognizer;

public class DroolsRuntimeManager
extends AbstractRuntimeManager {
    private static final String DROOLS_BUNDLE_RUNTIME_LOCATION = ".drools.runtime";
    private static final String DROOLS_SETTINGS_FILENAME = ".drools.runtime";
    private static final String DROOLS_BUNDLE_NAME = "org.drools.eclipse";
    private static final String DROOLS_RUNTIME_RECOGNIZER = "org.drools.eclipse.runtimeRecognizer";
    private static DroolsRuntimeManager manager;

    public static DroolsRuntimeManager getDefault() {
        if (manager == null) {
            manager = new DroolsRuntimeManager();
        }
        return manager;
    }

    public String getRuntimeWorkspaceLocation() {
        return ".drools.runtime";
    }

    public String getRuntimePreferenceKey() {
        return "Drools.Runtimes";
    }

    public String getSettingsFilename() {
        return ".drools.runtime";
    }

    public String getBundleSymbolicName() {
        return DROOLS_BUNDLE_NAME;
    }

    public IRuntime createNewRuntime() {
        return new DroolsRuntime();
    }

    public void logException(Throwable t) {
        DroolsEclipsePlugin.log(t);
    }

    public IPreferenceStore getPreferenceStore() {
        return DroolsEclipsePlugin.getDefault().getPreferenceStore();
    }

    public void addBuilder(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        ICommand[] commands;
        if (!DroolsClasspathContainer.hasDroolsClasspath(project)) {
            DroolsClasspathContainer cp = new DroolsClasspathContainer(project);
            JavaCore.setClasspathContainer((IPath)cp.getPath(), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{cp}, (IProgressMonitor)monitor);
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            list.addAll(Arrays.asList(project.getRawClasspath()));
            list.add(JavaCore.newContainerEntry((IPath)cp.getPath()));
            project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
        }
        IProjectDescription description = project.getProject().getDescription();
        ICommand[] iCommandArray = commands = description.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            if (cmd.getBuilderName().equals("org.drools.eclipse.droolsbuilder")) {
                return;
            }
            ++n2;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand droolsCommand = description.newCommand();
        droolsCommand.setBuilderName("org.drools.eclipse.droolsbuilder");
        newCommands[commands.length] = droolsCommand;
        description.setBuildSpec(newCommands);
        project.getProject().setDescription(description, monitor);
    }

    public IRuntimeRecognizer[] getRuntimeRecognizers() {
        ArrayList<IRuntimeRecognizer> recognizer = new ArrayList<IRuntimeRecognizer>();
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DROOLS_RUNTIME_RECOGNIZER);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IRuntimeRecognizer) {
                    recognizer.add((IRuntimeRecognizer)o);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        return recognizer.toArray(new IRuntimeRecognizer[recognizer.size()]);
    }
}

