/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.StateBasedNodeWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.workitem.WorkItemParameterMappingPropertyDescriptor;
import org.drools.eclipse.flow.ruleflow.view.property.workitem.WorkItemResultMappingPropertyDescriptor;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.WorkDefinition;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.WorkItemNode;

public class WorkItemWrapper
extends StateBasedNodeWrapper {
    public static final String WAIT_FOR_COMPLETION = "WaitForCompletion";
    public static final String RESULT_MAPPING = "ResultMapping";
    public static final String PARAMETER_MAPPING = "ParameterMapping";
    private static final long serialVersionUID = 510L;
    private WorkDefinition workDefinition;

    public WorkItemWrapper() {
        this.setNode((Node)new WorkItemNode());
    }

    public WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        if (this.workDefinition != null) {
            Work work = this.getWorkItemNode().getWork();
            if (work == null) {
                work = new WorkImpl();
                work.setName(this.workDefinition.getName());
                this.getWorkItemNode().setWork(work);
            }
            work.setParameterDefinitions(this.workDefinition.getParameters());
        }
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
        this.workDefinition = workDefinition;
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            work.setName(workDefinition.getName());
            this.getWorkItemNode().setWork(work);
        }
        work.setParameterDefinitions(workDefinition.getParameters());
    }

    public WorkDefinition getWorkDefinition() {
        return this.workDefinition;
    }

    private boolean workParameterExists(String parameterName) {
        if (this.workDefinition != null) {
            return this.workDefinition.getParameter(parameterName) != null;
        }
        return false;
    }

    @Override
    protected void initDescriptors() {
        super.initDescriptors();
        Set parameters = this.workDefinition.getParameters();
        IPropertyDescriptor[] oldDescriptors = this.descriptors;
        boolean fullProps = this.isFullProperties();
        this.descriptors = new IPropertyDescriptor[oldDescriptors.length + parameters.size() + (fullProps ? 5 : 4)];
        System.arraycopy(oldDescriptors, 0, this.descriptors, 0, oldDescriptors.length);
        int i = 0;
        for (ParameterDefinition def : parameters) {
            this.descriptors[oldDescriptors.length + i++] = new TextPropertyDescriptor((Object)def.getName(), def.getName());
        }
        if (fullProps) {
            this.descriptors[this.descriptors.length - 5] = new ComboBoxPropertyDescriptor((Object)WAIT_FOR_COMPLETION, "Wait for completion", new String[]{"true", "false"});
        }
        this.descriptors[this.descriptors.length - 4] = this.getOnEntryPropertyDescriptor();
        this.descriptors[this.descriptors.length - 3] = this.getOnExitPropertyDescriptor();
        this.descriptors[this.descriptors.length - 2] = new WorkItemParameterMappingPropertyDescriptor(PARAMETER_MAPPING, "Parameter Mapping", this.getWorkItemNode());
        this.descriptors[this.descriptors.length - 1] = new WorkItemResultMappingPropertyDescriptor(RESULT_MAPPING, "Result Mapping", this.getWorkItemNode());
    }

    @Override
    public boolean acceptsIncomingConnection(ElementConnection connection, ElementWrapper source) {
        return super.acceptsIncomingConnection(connection, source) && this.getIncomingConnections().isEmpty();
    }

    @Override
    public boolean acceptsOutgoingConnection(ElementConnection connection, ElementWrapper target) {
        return super.acceptsOutgoingConnection(connection, target) && this.getOutgoingConnections().isEmpty();
    }

    @Override
    public Object getPropertyValue(Object id) {
        String name;
        if (WAIT_FOR_COMPLETION.equals(id)) {
            return this.getWorkItemNode().isWaitForCompletion() ? new Integer(0) : new Integer(1);
        }
        if (PARAMETER_MAPPING.equals(id)) {
            return this.getWorkItemNode().getInMappings();
        }
        if (RESULT_MAPPING.equals(id)) {
            return this.getWorkItemNode().getOutMappings();
        }
        if (id instanceof String && this.workParameterExists(name = (String)id)) {
            DataType type = this.getWorkItemNode().getWork().getParameterDefinition(name).getType();
            Object value = this.getWorkItemNode().getWork().getParameter(name);
            if (value == null) {
                return "";
            }
            return type.writeValue(value);
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void resetPropertyValue(Object id) {
        if (WAIT_FOR_COMPLETION.equals(id)) {
            this.getWorkItemNode().setWaitForCompletion(true);
        } else if (PARAMETER_MAPPING.equals(id)) {
            this.getWorkItemNode().setInMappings(new HashMap());
        } else if (RESULT_MAPPING.equals(id)) {
            this.getWorkItemNode().setOutMappings(new HashMap());
        } else if (id instanceof String && this.workParameterExists((String)id)) {
            this.getWorkItemNode().getWork().setParameter((String)id, null);
        } else {
            super.resetPropertyValue(id);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (WAIT_FOR_COMPLETION.equals(id)) {
            this.getWorkItemNode().setWaitForCompletion((Integer)value == 0);
        } else if (PARAMETER_MAPPING.equals(id)) {
            this.getWorkItemNode().setInMappings((Map)value);
        } else if (RESULT_MAPPING.equals(id)) {
            this.getWorkItemNode().setOutMappings((Map)value);
        } else if (id instanceof String && this.workParameterExists((String)id)) {
            DataType type = this.getWorkItemNode().getWork().getParameterDefinition((String)id).getType();
            this.getWorkItemNode().getWork().setParameter((String)id, type.readValue((String)value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

