/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.http.client.ContentType;
import org.eclipse.webdav.http.client.IStatusCodes;
import org.eclipse.webdav.http.client.Message;
import org.eclipse.webdav.internal.kernel.DocumentMarshaler;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.w3c.dom.Document;

public class Response
extends Message
implements IResponse,
IStatusCodes {
    protected int statusCode;
    protected String statusMessage;
    protected boolean hasDocumentBody;
    protected Document document;

    public Response(int statusCode, String statusMessage, IContext context, InputStream inputStream) {
        super(context, inputStream);
        Assert.isTrue(statusCode >= 100 && statusCode < 600);
        Assert.isNotNull(statusMessage);
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.hasDocumentBody = false;
        ContentType contentType = this.getContentType();
        if (contentType != null) {
            this.hasDocumentBody = "xml".equals(contentType.getSubtype());
        }
    }

    public long getContentLength() {
        long contentLength = this.context.getContentLength();
        if (contentLength != -1L) {
            return contentLength;
        }
        int statusCode = this.getStatusCode();
        if (statusCode == 204 || statusCode == 304 || statusCode >= 100 && statusCode < 200) {
            return 0L;
        }
        return -1L;
    }

    public ContentType getContentType() {
        String contentTypeString = this.context.getContentType();
        if (contentTypeString == null) {
            return null;
        }
        ContentType contentType = null;
        try {
            contentType = new ContentType(contentTypeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return contentType;
    }

    public Document getDocumentBody() throws IOException {
        Assert.isTrue(this.hasDocumentBody);
        Assert.isTrue(!this.hasInputStream);
        if (this.document == null) {
            String characterEncoding = null;
            ContentType contentType = this.getContentType();
            if (contentType != null) {
                characterEncoding = contentType.getValue("charset");
            }
            if (characterEncoding == null) {
                characterEncoding = "ASCII";
            }
            DocumentMarshaler marshaler = new DocumentMarshaler();
            this.document = marshaler.parse(new InputStreamReader(this.is, characterEncoding));
        }
        return this.document;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean hasDocumentBody() {
        return this.hasDocumentBody;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.statusCode);
        buffer.append(' ');
        buffer.append(this.statusMessage);
        buffer.append('\n');
        buffer.append(super.toString());
        return buffer.toString();
    }
}

