/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.base.ClassTypeResolver;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.completion.CompletionContext;
import org.drools.eclipse.editors.completion.CompletionUtil;
import org.drools.eclipse.editors.completion.DefaultCompletionProcessor;
import org.drools.eclipse.editors.completion.ReflectionUtils;
import org.drools.eclipse.editors.completion.RuleCompletionProposal;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.lang.Location;
import org.drools.lang.descr.GlobalDescr;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.runtime.rule.RuleContext;
import org.drools.spi.KnowledgeHelper;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.compiler.PropertyVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleCompletionProcessor
extends DefaultCompletionProcessor {
    private static final String DIALECT = "dialect";
    private static final Image DROOLS_ICON = DroolsPluginImages.getImage("Drools");
    private static final Image CLASS_ICON = DroolsPluginImages.getImage("Class");
    private CompletionContext context;

    public RuleCompletionProcessor(AbstractRuleEditor editor) {
        super(editor);
    }

    @Override
    protected List getCompletionProposals(ITextViewer viewer, int documentOffset) {
        try {
            ArrayList<RuleCompletionProposal> list = new ArrayList<RuleCompletionProposal>();
            IDocument doc = viewer.getDocument();
            String backText = this.readBackwards(documentOffset, doc);
            String prefix = CompletionUtil.stripLastWord(backText);
            if (backText.length() < 5) {
                return list;
            }
            this.context = new CompletionContext(backText);
            Location location = this.context.getLocation();
            if (location.getType() == 2000) {
                this.addRuleHeaderProposals(list, documentOffset, prefix, backText);
            } else if (location.getType() == 1000) {
                this.addRHSCompletionProposals(list, documentOffset, prefix, backText, (String)location.getProperty("LHSContent"), (String)location.getProperty("RHSContent"));
            } else {
                this.addLHSCompletionProposals(list, documentOffset, location, prefix, backText);
            }
            RuleCompletionProcessor.filterProposalsOnPrefix(prefix, list);
            return list;
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
            return null;
        }
    }

    protected void addRHSCompletionProposals(List list, int documentOffset, String prefix, String backText, String conditions, String consequence) {
        boolean startOfDialectExpression;
        if (consequence == null || consequence.length() < prefix.length()) {
            return;
        }
        String consequenceWithoutPrefix = consequence.substring(0, consequence.length() - prefix.length());
        if (this.context == null) {
            this.context = new CompletionContext(backText);
        }
        if (startOfDialectExpression = CompletionUtil.isStartOfDialectExpression(consequenceWithoutPrefix)) {
            this.addRHSKeywordCompletionProposals(list, documentOffset, prefix);
            this.addRHSFunctionCompletionProposals(list, documentOffset, prefix);
        }
        if (this.isJavaDialect()) {
            this.addRHSJavaCompletionProposals(list, documentOffset, prefix, backText, consequence);
        } else if (this.isMvelDialect()) {
            this.addRHSMvelCompletionProposals(list, documentOffset, prefix, backText, consequence, startOfDialectExpression);
        }
    }

    private boolean isJavaDialect() {
        if (this.context.isJavaDialect()) {
            return true;
        }
        return this.context.isDefaultDialect() && (!this.getAttributes().containsKey(DIALECT) || this.hasPackageDialect("java"));
    }

    private boolean isMvelDialect() {
        if (this.context.isMvelDialect()) {
            return true;
        }
        return this.context.isDefaultDialect() && this.hasPackageDialect("mvel");
    }

    private boolean hasPackageDialect(String dialect) {
        String globalDialect = (String)this.getAttributes().get(DIALECT);
        return globalDialect != null && dialect.equalsIgnoreCase(globalDialect);
    }

    protected void addLHSCompletionProposals(List<RuleCompletionProposal> list, int documentOffset, Location location, String prefix, String backText) {
        switch (location.getType()) {
            case 1: {
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "and", "and ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "or", "or ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "from", "from ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "forall", "forall(  )", 8, DROOLS_ICON));
                RuleCompletionProposal prop = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "eval", "eval(  )", 6);
                prop.setImage(DROOLS_ICON);
                list.add(prop);
                prop = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "then", "then" + System.getProperty("line.separator") + "\t");
                prop.setImage(DROOLS_ICON);
                list.add(prop);
            }
            case 3: {
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "not", "not ", DROOLS_ICON));
            }
            case 4: {
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "exists", "exists ", DROOLS_ICON));
            }
            case 2: 
            case 301: 
            case 302: {
                RuleCompletionProposal p;
                String className;
                int index;
                for (String name : this.getImports()) {
                    index = name.lastIndexOf(".");
                    if (index == -1) continue;
                    className = name.substring(index + 1);
                    p = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), className, String.valueOf(className) + "(  )", className.length() + 2);
                    p.setPriority(-1);
                    p.setImage(CLASS_ICON);
                    list.add(p);
                }
                for (String name : this.getClassesInPackage()) {
                    index = name.lastIndexOf(".");
                    if (index == -1) continue;
                    className = name.substring(index + 1);
                    p = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), className, String.valueOf(className) + "(  )", className.length() + 2);
                    p.setPriority(-1);
                    p.setImage(CLASS_ICON);
                    list.add(p);
                }
                break;
            }
            case 100: {
                String className = (String)location.getProperty("ClassName");
                String propertyName = (String)location.getProperty("PropertyName");
                if (className == null) break;
                ClassTypeResolver resolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
                try {
                    String currentClass = className;
                    if (propertyName != null) {
                        String[] nestedProperties = propertyName.split("\\.");
                        int nbSuperProperties = nestedProperties.length - 1;
                        if (propertyName.endsWith(".")) {
                            ++nbSuperProperties;
                        }
                        int i = 0;
                        while (i < nbSuperProperties) {
                            String simplePropertyName = nestedProperties[i];
                            currentClass = this.getSimplePropertyClass(currentClass, simplePropertyName);
                            currentClass = this.convertToNonPrimitiveClass(currentClass);
                            ++i;
                        }
                    }
                    RuleCompletionProposal p = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "this");
                    p.setImage(METHOD_ICON);
                    list.add(p);
                    Class clazz = resolver.resolveType(currentClass);
                    if (clazz == null) break;
                    if (Map.class.isAssignableFrom(clazz)) {
                        p = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "this['']", "this['']", 6);
                        p.setImage(METHOD_ICON);
                        list.add(p);
                    }
                    ClassFieldInspector inspector = new ClassFieldInspector(clazz);
                    Map types = inspector.getFieldTypes();
                    for (String name : inspector.getFieldNames().keySet()) {
                        p = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), name, String.valueOf(name) + " ");
                        p.setImage(METHOD_ICON);
                        list.add(p);
                        Class type = (Class)types.get(name);
                        if (type == null || !Map.class.isAssignableFrom(type)) continue;
                        name = String.valueOf(name) + "['']";
                        p = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), name, name, name.length() - 2);
                        p.setImage(METHOD_ICON);
                        list.add(p);
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
                break;
            }
            case 101: {
                String className = (String)location.getProperty("ClassName");
                String property = (String)location.getProperty("PropertyName");
                String type = this.getPropertyClass(className, property);
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "==", "== ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "!=", "!= ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), ":", ": ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "->", "-> (  )", 5, DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "memberOf", "memberOf ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "not memberOf", "not memberOf ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "in", "in (  )", 5, DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "not in", "not in (  )", 9, DROOLS_ICON));
                if (this.isComparable(type)) {
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "<", "< ", DROOLS_ICON));
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "<=", "<= ", DROOLS_ICON));
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), ">", "> ", DROOLS_ICON));
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), ">=", ">= ", DROOLS_ICON));
                }
                if (type.equals("java.lang.String")) {
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "matches", "matches \"\"", 9, DROOLS_ICON));
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "not matches", "not matches \"\"", 13, DROOLS_ICON));
                }
                if (!this.isSubtypeOf(type, "java.util.Collection")) break;
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "contains", "contains ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "not contains", "not contains ", DROOLS_ICON));
                break;
            }
            case 102: {
                RuleCompletionProposal proposal;
                String className = (String)location.getProperty("ClassName");
                String property = (String)location.getProperty("PropertyName");
                String operator = (String)location.getProperty("Operator");
                String type = this.getPropertyClass(className, property);
                if ("in".equals(operator)) {
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "()", "(  )", 2, DROOLS_ICON));
                    break;
                }
                if ("contains".equals(operator) || "excludes".equals(operator)) {
                    type = "java.lang.Object";
                }
                if ("memberOf".equals(operator)) {
                    type = "java.util.Collection";
                }
                boolean isObject = false;
                if ("java.lang.Object".equals(type)) {
                    isObject = true;
                }
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "null", "null ", DROOLS_ICON));
                if ("boolean".equals(type)) {
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "true", "true ", DROOLS_ICON));
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "false", "false ", DROOLS_ICON));
                }
                if (isObject || "java.lang.String".equals(type)) {
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "\"\"", "\"\"", 1, DROOLS_ICON));
                }
                if (isObject || "java.util.Date".equals(type)) {
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "\"dd-mmm-yyyy\"", "\"dd-mmm-yyyy\"", 1, DROOLS_ICON));
                }
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "()", "(  )", 2, DROOLS_ICON));
                HashMap<String, String> result = new HashMap<String, String>();
                this.addRuleParameters(result, this.context.getRuleParameters());
                for (Map.Entry entry : result.entrySet()) {
                    String paramName = (String)entry.getKey();
                    String paramType = (String)entry.getValue();
                    if (!this.isSubtypeOf(paramType, type)) continue;
                    proposal = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), paramName);
                    proposal.setPriority(-1);
                    proposal.setImage(VARIABLE_ICON);
                    list.add(proposal);
                }
                List<GlobalDescr> globals = this.getGlobals();
                if (globals == null) break;
                for (GlobalDescr global : globals) {
                    if (!this.isSubtypeOf(global.getType(), type)) continue;
                    proposal = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), global.getIdentifier());
                    proposal.setPriority(-1);
                    proposal.setImage(VARIABLE_ICON);
                    list.add(proposal);
                }
                break;
            }
            case 200: {
                String content = (String)location.getProperty("EvalContent");
                list.addAll(this.getJavaCompletionProposals(documentOffset, content, prefix, this.getRuleParameters(backText)));
                break;
            }
            case 103: {
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "&&", "&& ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "||", "|| ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), ",", ", ", DROOLS_ICON));
                break;
            }
            case 300: {
                String fromText = (String)location.getProperty("FromContent");
                int index = fromText.indexOf(46);
                if (index != -1) break;
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "accumulate", "accumulate (  , init (  ), action (  ), result (  ) )", 13, DROOLS_ICON));
                PackageBuilderConfiguration config = new PackageBuilderConfiguration(new ClassLoader[]{ProjectClassLoader.getProjectClassLoader(this.getEditor()), null});
                Map accumulateFunctions = config.getAccumulateFunctionsMap();
                for (String accumulateFunction : accumulateFunctions.keySet()) {
                    list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "accumulate " + accumulateFunction, "accumulate (  , " + accumulateFunction + "(  ) )", 13, DROOLS_ICON));
                }
                list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "collect", "collect (  )", 10, DROOLS_ICON));
                if ("".equals(fromText)) {
                    List functions = this.getFunctions();
                    Iterator iterator = functions.iterator();
                    while (iterator.hasNext()) {
                        String name = String.valueOf((String)iterator.next()) + "()";
                        RuleCompletionProposal prop = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), name, name, name.length() - 1);
                        prop.setPriority(-1);
                        prop.setImage(METHOD_ICON);
                        list.add(prop);
                    }
                }
                list.addAll(this.getJavaCompletionProposals(documentOffset, fromText, prefix, this.getRuleParameters(backText)));
                break;
            }
            case 304: {
                String content = (String)location.getProperty("FromAccumulateInitContent");
                list.addAll(this.getJavaCompletionProposals(documentOffset, content, prefix, this.getRuleParameters(backText)));
                break;
            }
            case 306: {
                String content = (String)location.getProperty("FromAccumulateInitContent");
                content = String.valueOf(content) + (String)location.getProperty("FromAccumulateActionContent");
                list.addAll(this.getJavaCompletionProposals(documentOffset, content, prefix, this.getRuleParameters(backText)));
                break;
            }
            case 310: {
                String content = (String)location.getProperty("FromAccumulateInitContent");
                content = String.valueOf(content) + (String)location.getProperty("FromAccumulateActionContent");
                content = String.valueOf(content) + (String)location.getProperty("FromAccumulateResultContent");
                list.addAll(this.getJavaCompletionProposals(documentOffset, content, prefix, this.getRuleParameters(backText)));
            }
        }
    }

    private String getPropertyClass(String className, String propertyName) {
        if (className != null && propertyName != null) {
            String[] nestedProperties = propertyName.split("\\.");
            String currentClass = className;
            int i = 0;
            while (i < nestedProperties.length) {
                String simplePropertyName = nestedProperties[i];
                currentClass = this.getSimplePropertyClass(currentClass, simplePropertyName);
                ++i;
            }
            return currentClass;
        }
        return null;
    }

    private String getSimplePropertyClass(String className, String propertyName) {
        if ("this".equals(propertyName)) {
            return className;
        }
        if (propertyName.endsWith("]")) {
            return "java.lang.Object";
        }
        ClassTypeResolver resolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
        try {
            Class clazzz;
            Class clazz = resolver.resolveType(className);
            if (clazz != null && (clazzz = (Class)new ClassFieldInspector(clazz).getFieldTypes().get(propertyName)) != null) {
                return clazzz.getName();
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return "java.lang.Object";
    }

    private Map getRuleParameters(String backText) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<GlobalDescr> globals = this.getGlobals();
        if (globals != null) {
            for (GlobalDescr global : globals) {
                result.put(global.getIdentifier(), global.getType());
            }
        }
        if (this.context == null) {
            this.context = new CompletionContext(backText);
        }
        this.addRuleParameters(result, this.context.getRuleParameters());
        return result;
    }

    private boolean isComparable(String type) {
        if (type == null) {
            return false;
        }
        if (this.isPrimitiveNumericType(type)) {
            return true;
        }
        if (this.isObjectNumericType(type)) {
            return true;
        }
        return this.isSubtypeOf(type, "java.lang.Comparable");
    }

    private boolean isPrimitiveType(String type) {
        return this.isPrimitiveNumericType(type) || type.equals("boolean");
    }

    private boolean isPrimitiveNumericType(String type) {
        return type.equals("byte") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double") || type.equals("char");
    }

    private boolean isObjectNumericType(String type) {
        return type.equals("java.lang.Byte") || type.equals("java.lang.Short") || type.equals("java.lang.Integer") || type.equals("java.lang.Long") || type.equals("java.lang.Float") || type.equals("java.lang.Double") || type.equals("java.lang.Char");
    }

    private boolean isSubtypeOf(String class1, String class2) {
        Class clazz2;
        Class clazz1;
        block4: {
            if (class1 == null || class2 == null) {
                return false;
            }
            class1 = this.convertToNonPrimitiveClass(class1);
            class2 = this.convertToNonPrimitiveClass(class2);
            ClassTypeResolver resolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
            try {
                clazz1 = resolver.resolveType(class1);
                clazz2 = resolver.resolveType(class2);
                if (clazz1 != null && clazz2 != null) break block4;
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return clazz2.isAssignableFrom(clazz1);
    }

    private String convertToNonPrimitiveClass(String clazz) {
        if (!this.isPrimitiveType(clazz)) {
            return clazz;
        }
        if ("byte".equals(clazz)) {
            return "java.lang.Byte";
        }
        if ("short".equals(clazz)) {
            return "java.lang.Short";
        }
        if ("int".equals(clazz)) {
            return "java.lang.Integer";
        }
        if ("long".equals(clazz)) {
            return "java.lang.Long";
        }
        if ("float".equals(clazz)) {
            return "java.lang.Float";
        }
        if ("double".equals(clazz)) {
            return "java.lang.Double";
        }
        if ("char".equals(clazz)) {
            return "java.lang.Char";
        }
        if ("boolean".equals(clazz)) {
            return "java.lang.Boolean";
        }
        return null;
    }

    private void addRHSFunctionCompletionProposals(List list, int documentOffset, String prefix) {
        List functions = this.getFunctions();
        Iterator iterator = functions.iterator();
        while (iterator.hasNext()) {
            String name = String.valueOf((String)iterator.next()) + "()";
            RuleCompletionProposal prop = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), name, String.valueOf(name) + ";", name.length() - 1);
            prop.setPriority(-1);
            prop.setImage(METHOD_ICON);
            list.add(prop);
        }
    }

    private void addRHSKeywordCompletionProposals(List list, int documentOffset, String prefix) {
        RuleCompletionProposal prop = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "update", "update();", 7);
        prop.setImage(DROOLS_ICON);
        list.add(prop);
        prop = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "retract", "retract();", 8);
        prop.setImage(DROOLS_ICON);
        list.add(prop);
        prop = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "insert", "insert();", 7);
        prop.setImage(DROOLS_ICON);
        list.add(prop);
        prop = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "insertLogical", "insertLogical();", 14);
        prop.setImage(DROOLS_ICON);
        list.add(prop);
    }

    private void addRHSJavaCompletionProposals(List list, int documentOffset, String prefix, String backText, String consequence) {
        list.addAll(this.getJavaCompletionProposals(documentOffset, consequence, prefix, this.getRuleParameters(backText)));
    }

    private void addRHSMvelCompletionProposals(List list, int documentOffset, String prefix, String backText, String consequence, boolean expressionStart) {
        Collection mvelCompletionProposals = this.getMvelCompletionProposals(consequence, documentOffset, prefix, this.getRuleParameters(backText), backText, expressionStart);
        list.addAll(mvelCompletionProposals);
    }

    private Collection getMvelCompletionProposals(String consequenceBackText, int documentOffset, String prefix, Map params, String ruleBackText, boolean startOfExpression) {
        HashSet<RuleCompletionProposal> proposals = new HashSet<RuleCompletionProposal>();
        if (!(this.getEditor().getEditorInput() instanceof IFileEditorInput)) {
            return proposals;
        }
        try {
            boolean isModifyBlock;
            DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().generateParsedResource("package dummy; \n" + ruleBackText, (IResource)((IFileEditorInput)this.getEditor().getEditorInput()).getFile(), false, false);
            String textWithoutPrefix = CompletionUtil.getTextWithoutPrefix(consequenceBackText, prefix);
            boolean expressionStart = CompletionUtil.isStartOfDialectExpression(textWithoutPrefix);
            boolean isConstrained = textWithoutPrefix.endsWith(".");
            String previousExpression = CompletionUtil.getPreviousExpression(consequenceBackText);
            MvelContext previousExprContext = this.analyzeMvelExpression(this.getResolvedMvelInputs(params), drlInfo, previousExpression);
            HashMap variables = previousExprContext.getContext().getVariables();
            Map inputs = previousExprContext.getContext().getInputs();
            inputs.putAll(variables);
            String lastInnerExpression = CompletionUtil.getTextWithoutPrefix(CompletionUtil.getInnerExpression(consequenceBackText), prefix);
            String compilableLastInnerExpression = CompletionUtil.getCompilableText(lastInnerExpression);
            MvelContext lastInnerExprContext = this.analyzeMvelExpression(inputs, drlInfo, compilableLastInnerExpression);
            String lastExpression = CompletionUtil.getLastExpression(consequenceBackText).trim();
            Matcher modMatcher = CompletionUtil.MODIFY_PATTERN.matcher(lastExpression);
            boolean bl = isModifyBlock = modMatcher.matches() && modMatcher.groupCount() == 3;
            if (isConstrained) {
                if (lastInnerExprContext.isStaticFlag()) {
                    return this.getMvelClassCompletionsFromJDT(documentOffset, "", params, lastInnerExprContext.getReturnedType());
                }
                return this.getMvelInstanceCompletionsFromJDT(documentOffset, "", params, lastInnerExprContext.getReturnedType(), false);
            }
            if (expressionStart && isModifyBlock) {
                String modifyVar = modMatcher.group(1);
                MvelContext modVarContext = this.analyzeMvelExpression(inputs, drlInfo, modifyVar);
                Class modVarType = modVarContext.getReturnedType();
                Collection modVarComps = this.getMvelInstanceCompletionsFromJDT(documentOffset, "", params, modVarType, true);
                proposals.addAll(modVarComps);
                return proposals;
            }
            RuleCompletionProcessor.addMvelCompletions(proposals, documentOffset, prefix, lastInnerExprContext.getContext().getVariables());
            RuleCompletionProcessor.addMvelCompletions(proposals, documentOffset, prefix, lastInnerExprContext.getContext().getInputs());
            List<RuleCompletionProposal> jdtProps = this.getJavaCompletionProposals(documentOffset, prefix, prefix, params);
            proposals.addAll(jdtProps);
        }
        catch (Throwable e) {
            DroolsEclipsePlugin.log(e);
        }
        HashSet uniqueProposals = new HashSet();
        RuleCompletionProcessor.addAllNewProposals(uniqueProposals, proposals);
        return uniqueProposals;
    }

    private Map getResolvedMvelInputs(Map params) {
        ClassTypeResolver resolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
        HashMap resolved = new HashMap();
        for (Map.Entry entry : params.entrySet()) {
            String inputType = (String)entry.getValue();
            try {
                Class type = resolver.resolveType(inputType);
                resolved.put(entry.getKey(), type);
            }
            catch (ClassNotFoundException e) {
                DroolsEclipsePlugin.log(e);
            }
        }
        return resolved;
    }

    private MvelContext analyzeMvelExpression(Map params, DRLInfo drlInfo, String mvel) {
        String macroMvel = RuleCompletionProcessor.processMacros(mvel);
        String name = this.context.getRuleName();
        RuleCompletionProcessor.getCurrentRule(drlInfo, name);
        String qName = String.valueOf(drlInfo.getPackageName()) + "." + name;
        MVELDialect dialect = (MVELDialect)drlInfo.getDialectRegistry().getDialect("mvel");
        ParserContext initialContext = RuleCompletionProcessor.createInitialContext(params, qName, dialect);
        MvelContext mCon = new MvelContext();
        mCon.setInitialContext(initialContext);
        try {
            ExpressionCompiler compiler = new ExpressionCompiler(macroMvel);
            CompiledExpression expression = compiler.compile(initialContext);
            mCon.setExpression(expression);
            ParserContext compilationContext = compiler.getParserContextState();
            Class<Object> lastType = expression.getKnownEgressType();
            if (lastType != null && "java.lang.Class".equals(lastType.getName())) {
                mCon.setStaticFlag(true);
            }
            if (lastType == null || "java.lang.Object".equals(lastType.getName()) || "java.lang.Class".equals(lastType.getName())) {
                lastType = new PropertyVerifier(macroMvel, compilationContext).analyze();
            }
            if (lastType == null) {
                lastType = Object.class;
            }
            mCon.setReturnedType(lastType);
        }
        catch (Exception exception) {}
        return mCon;
    }

    private static ParserContext createInitialContext(Map params, String qualifiedName, MVELDialect dialect) {
        PackageRegistry packageRegistry = dialect.getPackageRegistry();
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)packageRegistry.getDialectRuntimeRegistry().getDialectData(dialect.getId());
        ParserConfiguration pconf = data.getParserConfiguration();
        ParserContext context = new ParserContext(pconf.getImports(), null, qualifiedName);
        if (pconf.getPackageImports() != null) {
            for (String packageImport : pconf.getPackageImports()) {
                context.addPackageImport(packageImport);
            }
        }
        context.setStrictTypeEnforcement(false);
        context.setInterceptors(dialect.getInterceptors());
        context.setInputs(params);
        context.addInput("drools", KnowledgeHelper.class);
        context.addInput("kcontext", RuleContext.class);
        context.setCompiled(true);
        return context;
    }

    public static String processMacros(String mvel) {
        MVELConsequenceBuilder builder = new MVELConsequenceBuilder();
        String macrosProcessedCompilableConsequence = MVELConsequenceBuilder.processMacros((String)mvel.trim());
        return macrosProcessedCompilableConsequence;
    }

    private static DRLInfo.RuleInfo getCurrentRule(DRLInfo drlInfo, String currentRulename) {
        DRLInfo.RuleInfo currentRule = null;
        DRLInfo.RuleInfo[] ruleInfos = drlInfo.getRuleInfos();
        int i = 0;
        while (i < ruleInfos.length) {
            if (currentRulename.equals(ruleInfos[i].getRuleName())) {
                currentRule = ruleInfos[i];
                break;
            }
            ++i;
        }
        return currentRule;
    }

    private Collection getMvelInstanceCompletionsFromJDT(int documentOffset, String prefix, Map params, Class lastType, boolean settersOnly) {
        if (lastType == null) {
            lastType = Object.class;
        }
        String javaText = "\n" + lastType.getPackage().getName() + "." + CompletionUtil.getSimpleClassName(lastType) + " " + "mvdrlofc" + ";\n" + "mvdrlofc" + ".";
        ArrayList list1 = new ArrayList();
        this.requestJavaCompletionProposals(javaText, prefix, documentOffset, params, list1);
        ArrayList list = list1;
        Collection mvelList = RuleCompletionProcessor.mvelifyProposals(list, settersOnly);
        return mvelList;
    }

    private Collection getMvelClassCompletionsFromJDT(int documentOffset, String prefix, Map params, Class lastType) {
        if (lastType == null) {
            lastType = Object.class;
        }
        String javaText = "\n" + CompletionUtil.getSimpleClassName(lastType) + ".";
        ArrayList list1 = new ArrayList();
        this.requestJavaCompletionProposals(javaText, prefix, documentOffset, params, list1);
        ArrayList list = list1;
        Collection mvelList = RuleCompletionProcessor.mvelifyProposals(list, false);
        return mvelList;
    }

    private static void addMvelCompletions(Collection proposals, int documentOffset, String prefix, Map inputs) {
        HashSet<RuleCompletionProposal> newProposals = new HashSet<RuleCompletionProposal>();
        for (Map.Entry entry : inputs.entrySet()) {
            String prop = (String)entry.getKey();
            Class type = (Class)entry.getValue();
            String display = String.valueOf(prop) + "  " + CompletionUtil.getSimpleClassName(type);
            RuleCompletionProposal rcp = new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), display, prop);
            rcp.setImage(DefaultCompletionProcessor.VARIABLE_ICON);
            newProposals.add(rcp);
        }
        RuleCompletionProcessor.addAllNewProposals(proposals, newProposals);
    }

    public static void addAllNewProposals(Collection proposals, Collection newProposals) {
        for (ICompletionProposal newProp : newProposals) {
            String displayString = newProp.getDisplayString();
            if (RuleCompletionProcessor.containsProposal(proposals, displayString)) continue;
            proposals.add(newProp);
        }
    }

    public static boolean containsProposal(Collection proposals, String newProposal) {
        for (ICompletionProposal prop : proposals) {
            String[] newProposals;
            String displayString = prop.getDisplayString();
            String[] existings = displayString.split(" ");
            if (existings.length == 0 || (newProposals = newProposal.split(" ")).length == 0 || !existings[0].equals(newProposals[0])) continue;
            return true;
        }
        return false;
    }

    private void addRuleParameters(Map<String, String> result, Map<String, String[]> ruleParameters) {
        for (Map.Entry<String, String[]> entry : ruleParameters.entrySet()) {
            String name = entry.getKey();
            String clazz = entry.getValue()[0];
            String field = entry.getValue()[1];
            String type = field == null ? clazz : this.getPropertyClass(clazz, field);
            result.put(name, type);
        }
    }

    private void addRuleHeaderProposals(List list, int documentOffset, String prefix, String backText) {
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "salience", "salience ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "no-loop", "no-loop ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "agenda-group", "agenda-group ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "duration", "duration ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "auto-focus", "auto-focus ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "when", "when" + System.getProperty("line.separator") + "\t ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "activation-group", "activation-group ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "date-effective", "date-effective \"dd-MMM-yyyy\"", 16, DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "date-expires", "date-expires \"dd-MMM-yyyy\"", 14, DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "enabled", "enabled false", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "ruleflow-group", "ruleflow-group \"\"", 16, DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "lock-on-active", "lock-on-active ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "dialect \"java\"", "dialect \"java\" ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(documentOffset - prefix.length(), prefix.length(), "dialect \"mvel\"", "dialect \"mvel\" ", DROOLS_ICON));
    }

    public static Collection mvelifyProposals(List list, boolean settersOnly) {
        HashSet set = new HashSet();
        for (Object o : list) {
            if (o instanceof JavaMethodCompletionProposal) {
                RuleCompletionProcessor.processJavaMethodCompletionProposal(list, settersOnly, set, o);
                continue;
            }
            if (o instanceof JavaCompletionProposal) {
                RuleCompletionProcessor.processesJavaCompletionProposal(settersOnly, set, o);
                continue;
            }
            if (settersOnly) continue;
            set.add(o);
        }
        return set;
    }

    private static void processesJavaCompletionProposal(boolean settersOnly, Collection set, Object o) {
        if (settersOnly) {
            JavaCompletionProposal jcp = (JavaCompletionProposal)o;
            IJavaElement javaElement = jcp.getJavaElement();
            if (javaElement.getElementType() == 8) {
                set.add(o);
            }
        } else {
            set.add(o);
        }
    }

    private static void processJavaMethodCompletionProposal(List list, boolean settersOnly, Collection set, Object o) {
        LazyJavaCompletionProposal javaProposal = (LazyJavaCompletionProposal)o;
        Object field = ReflectionUtils.getField(o, "fProposal");
        if (field != null && field instanceof CompletionProposal) {
            CompletionProposal proposal = (CompletionProposal)field;
            String completion = new String(proposal.getCompletion());
            String propertyOrMethodName = null;
            boolean isSetter = false;
            boolean isAccessor = false;
            if (settersOnly) {
                propertyOrMethodName = CompletionUtil.getWritablePropertyName(completion, proposal.getSignature());
                isSetter = !completion.equals(propertyOrMethodName);
            } else {
                propertyOrMethodName = CompletionUtil.getPropertyName(completion, proposal.getSignature());
                isAccessor = !completion.equals(propertyOrMethodName);
            }
            boolean doesNotContainFieldCompletion = DefaultCompletionProcessor.doesNotContainFieldCompletion(propertyOrMethodName, list);
            if ((settersOnly && isSetter || !settersOnly && isAccessor) && doesNotContainFieldCompletion) {
                RuleCompletionProposal prop = new RuleCompletionProposal(javaProposal.getReplacementOffset(), javaProposal.getReplacementLength(), propertyOrMethodName);
                prop.setImage(DefaultCompletionProcessor.VARIABLE_ICON);
                prop.setPriority(1000);
                set.add(prop);
            } else if (!settersOnly) {
                set.add(o);
            }
        }
    }

    class MvelContext {
        private CompiledExpression expression;
        private ParserContext initialContext;
        private Class returnedType;
        private boolean staticFlag;

        MvelContext() {
        }

        public ParserContext getContext() {
            if (this.getExpression() != null && this.getExpression().getParserContext() != null) {
                return this.getExpression().getParserContext();
            }
            return this.getInitialContext();
        }

        void setExpression(CompiledExpression expression) {
            this.expression = expression;
        }

        CompiledExpression getExpression() {
            return this.expression;
        }

        void setInitialContext(ParserContext initialContext) {
            this.initialContext = initialContext;
        }

        ParserContext getInitialContext() {
            return this.initialContext;
        }

        void setReturnedType(Class returnedType) {
            this.returnedType = returnedType;
        }

        Class getReturnedType() {
            return this.returnedType;
        }

        public boolean isStaticFlag() {
            return this.staticFlag;
        }

        public void setStaticFlag(boolean staticFlag) {
            this.staticFlag = staticFlag;
        }
    }
}

