/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Property;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Bindings
extends Property {
    protected static final String[] childNames = new String[]{"href", "segment"};

    public Bindings(Element root) throws MalformedElementException {
        super(root, "bindings");
    }

    public void addBinding(String href, String segment) {
        Assert.isNotNull(href);
        Assert.isNotNull(segment);
        Bindings.appendChild(this.root, "href", Bindings.encodeHref(href));
        Bindings.appendChild(this.root, "segment", segment);
    }

    public Enumeration getBindings() throws MalformedElementException {
        Element firstHref = Bindings.getFirstChild(this.root, "href");
        Element segment = null;
        if (firstHref != null) {
            segment = Bindings.getNextSibling(firstHref, "segment");
        }
        Element firstSegment = segment;
        Enumeration e = new Enumeration(firstHref, firstSegment){
            Node fCurrentHref;
            Node fCurrentSegment;
            {
                this.fCurrentHref = node;
                this.fCurrentSegment = node2;
            }

            public boolean hasMoreElements() {
                return this.fCurrentHref != null && this.fCurrentSegment != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String nextHref = Bindings.getFirstText((Element)this.fCurrentHref);
                String nextSegment = Bindings.getFirstText((Element)this.fCurrentSegment);
                Binding nextBinding = new Binding(Bindings.decodeHref(nextHref), nextSegment);
                this.fCurrentHref = Bindings.getNextSibling((Element)this.fCurrentSegment, "href");
                this.fCurrentSegment = null;
                if (this.fCurrentHref != null) {
                    this.fCurrentSegment = Bindings.getNextSibling((Element)this.fCurrentHref, "segment");
                }
                return nextBinding;
            }
        };
        return e;
    }

    public class Binding {
        private String fHref = null;
        private String fSegment = null;

        public Binding(String href, String segment) {
            Assert.isNotNull(href);
            Assert.isNotNull(segment);
            this.fHref = href;
            this.fSegment = segment;
        }

        public String getHref() {
            return this.fHref;
        }

        public String getSegment() {
            return this.fSegment;
        }
    }
}

