/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.repository;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.PullOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.pull.PullResultDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.kie.eclipse.IKieConstants;
import org.kie.eclipse.navigator.Activator;
import org.kie.eclipse.navigator.view.actions.repository.KieCredentialsProvider;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;

public class PullOperationUI
extends JobChangeAdapter
implements IKieConstants {
    private static final IStatus NOT_TRIED_STATUS;
    private final Repository repository;
    private final Shell shell;
    private final String repoName;
    private final RepositoryNode repoNode;
    private final AtomicInteger tasksToWaitFor = new AtomicInteger(1);
    protected final Map<Repository, Object> results = Collections.synchronizedMap(new LinkedHashMap());
    private final PullOperation pullOperation;

    static {
        Activator.getDefault();
        NOT_TRIED_STATUS = new Status(4, "org.kie.eclipse.navigator", "Not tried");
    }

    public PullOperationUI(RepositoryNode container) {
        this.repoNode = container;
        IKieRepositoryHandler handler = (IKieRepositoryHandler)container.getHandler();
        IKieServerHandler serverHandler = (IKieServerHandler)handler.getRoot();
        IKieServiceDelegate delegate = handler.getDelegate();
        this.repository = handler.getRepository();
        this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.repoName = handler.getName();
        String username = delegate.getUsername();
        String password = delegate.getPassword();
        KieCredentialsProvider credentialsProvider = new KieCredentialsProvider(serverHandler, username, password);
        int timeout = serverHandler.getPreference("RemoteTimeout", 60);
        HashSet<Repository> repos = new HashSet<Repository>();
        repos.add(this.repository);
        this.pullOperation = new PullOperation(repos, timeout);
        this.pullOperation.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        this.results.put(this.repository, NOT_TRIED_STATUS);
    }

    public void start() {
        this.start((IJobChangeListener)this);
    }

    private void start(IJobChangeListener jobChangeListener) {
        String shortBranchName;
        try {
            shortBranchName = this.repository.getBranch();
        }
        catch (IOException iOException) {
            shortBranchName = "";
        }
        String jobName = NLS.bind((String)"Pulling Branch {0} of Repository {1}", (Object)shortBranchName, (Object)this.repoName);
        WorkspaceJob job = new WorkspaceJob(jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                PullOperationUI.this.execute(monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.PULL.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setRule(null);
        job.setUser(true);
        job.addJobChangeListener(jobChangeListener);
        job.schedule();
    }

    public void execute(IProgressMonitor monitor) {
        try {
            this.pullOperation.execute(monitor);
            this.results.putAll(this.pullOperation.getResults());
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                this.results.putAll(this.pullOperation.getResults());
            }
            this.repoNode.handleException(e);
        }
    }

    public void done(IJobChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LinkedHashMap<Repository, Object> res = new LinkedHashMap<Repository, Object>(PullOperationUI.this.results);
                PullOperationUI.this.handlePullResults(res);
            }
        });
    }

    private void handlePullResults(Map<Repository, Object> resultsMap) {
        if (this.tasksToWaitFor.decrementAndGet() == 0 && !this.results.isEmpty()) {
            this.showResults();
        }
    }

    private void showResults() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PullOperationUI.this.showResults(PullOperationUI.this.shell);
            }
        });
    }

    private void showResults(Shell shell) {
        if (this.results.isEmpty()) {
            return;
        }
        Map.Entry<Repository, Object> entry = this.results.entrySet().iterator().next();
        if (entry.getValue() instanceof PullResult) {
            new PullResultDialog(shell, entry.getKey(), (PullResult)entry.getValue()).open();
        } else {
            IStatus status = (IStatus)entry.getValue();
            if (status == NOT_TRIED_STATUS) {
                MessageDialog.openInformation((Shell)shell, (String)"Pull Canceled", (String)"The pull operation was canceled.");
            } else if (status.getException() instanceof TransportException) {
                ErrorDialog.openError((Shell)shell, (String)"Pull Failed", (String)"Git connection problem.\n\n\nMaybe you are offline or behind a proxy.\nCheck your network connection and proxy configuration.", (IStatus)status);
            } else {
                this.repoNode.handleException(status.getException());
            }
        }
    }
}

