/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.webdav.IResponse;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.ResourceHistoryView;
import org.guvnor.tools.views.model.TreeObject;

public class ShowHistoryAction
implements IObjectActionDelegate {
    private IFile selectedFile;
    private TreeObject selectedNode;
    private GuvnorMetadataProps props;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        block22: {
            String repositoryLoc = null;
            String fullPath = null;
            if (this.selectedNode != null) {
                repositoryLoc = this.selectedNode.getGuvnorRepository().getLocation();
                fullPath = this.selectedNode.getFullPath();
            } else {
                if (this.selectedFile == null || this.props == null) {
                    return;
                }
                repositoryLoc = this.props.getRepository();
                fullPath = this.props.getFullpath();
            }
            IResponse response = null;
            try {
                try {
                    InputStream ins;
                    block21: {
                        IWebDavClient client = WebDavServerCache.getWebDavClient(repositoryLoc);
                        if (client == null) {
                            client = WebDavClientFactory.createClient(new URL(repositoryLoc));
                            WebDavServerCache.cacheWebDavClient(repositoryLoc, client);
                        }
                        ins = null;
                        try {
                            response = client.getResourceVersions(fullPath);
                            ins = response.getInputStream();
                        }
                        catch (WebDavException wde) {
                            if (wde.getErrorCode() != 401) {
                                throw wde;
                            }
                            boolean retry = PlatformUtils.getInstance().authenticateForServer(repositoryLoc, client);
                            if (!retry) break block21;
                            response = client.getResourceVersions(fullPath);
                            ins = response.getInputStream();
                        }
                    }
                    if (ins != null) {
                        Properties verProps = new Properties();
                        verProps.load(ins);
                        ResourceHistoryView view = PlatformUtils.getResourceHistoryView();
                        if (view != null) {
                            view.setEntries(repositoryLoc, fullPath, verProps);
                        }
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().displayError(4, e.getMessage(), e, true);
                    if (response == null) break block22;
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        Activator.getDefault().writeLog(4, ioe.getMessage(), ioe);
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        Activator.getDefault().writeLog(4, ioe.getMessage(), ioe);
                    }
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedFile = null;
        this.selectedNode = null;
        this.props = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() != 1) {
            return;
        }
        if (sel.getFirstElement() instanceof IFile) {
            try {
                this.props = GuvnorMetadataUtils.getGuvnorMetadata((IResource)((IFile)sel.getFirstElement()));
                if (this.props != null) {
                    this.selectedFile = (IFile)sel.getFirstElement();
                    action.setEnabled(true);
                }
            }
            catch (Exception e) {
                Activator.getDefault().writeLog(4, e.getMessage(), e);
            }
        }
        if (sel.getFirstElement() instanceof TreeObject && ((TreeObject)sel.getFirstElement()).getNodeType() == TreeObject.Type.RESOURCE) {
            this.selectedNode = (TreeObject)sel.getFirstElement();
            action.setEnabled(true);
        }
    }
}

