/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.webdav.IResponse;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.VersionChooserDialog;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.model.ResourceHistoryEntry;

public class SwitchVersionAction
implements IObjectActionDelegate {
    private IFile selectedFile;
    private GuvnorMetadataProps props;
    private IWorkbenchPart targetPart;
    private IWebDavClient client;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.selectedFile == null || this.props == null || this.targetPart == null) {
            return;
        }
        VersionChooserDialog dialog = new VersionChooserDialog(this.targetPart.getSite().getShell(), this.selectedFile.getName(), this.getVersionEntries());
        if (dialog.open() == 0) {
            this.updateSelectedFile(dialog.getSelectedEntry());
            PlatformUtils.updateDecoration();
        }
    }

    private void updateSelectedFile(ResourceHistoryEntry verInfo) {
        block13: {
            IResponse response = null;
            try {
                try {
                    response = this.client.getResourceVersionInputStream(this.props.getFullpath(), verInfo.getRevision());
                    InputStream ins = response.getInputStream();
                    if (ins != null) {
                        this.selectedFile.setContents(ins, true, true, null);
                        GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)this.selectedFile);
                        GuvnorMetadataProps mdProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)this.selectedFile);
                        mdProps.setVersion(verInfo.getDate());
                        mdProps.setRevision(verInfo.getRevision());
                        GuvnorMetadataUtils.setGuvnorMetadataProps(this.selectedFile.getFullPath(), mdProps);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().displayError(4, e.getMessage(), e, true);
                    if (response == null) break block13;
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        Activator.getDefault().writeLog(4, ioe.getMessage(), ioe);
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        Activator.getDefault().writeLog(4, ioe.getMessage(), ioe);
                    }
                }
            }
        }
    }

    private ResourceHistoryEntry[] getVersionEntries() {
        ResourceHistoryEntry[] entries;
        block18: {
            entries = new ResourceHistoryEntry[]{};
            IResponse response = null;
            try {
                try {
                    InputStream ins;
                    block17: {
                        this.client = WebDavServerCache.getWebDavClient(this.props.getRepository());
                        if (this.client == null) {
                            this.client = WebDavClientFactory.createClient(new URL(this.props.getRepository()));
                            WebDavServerCache.cacheWebDavClient(this.props.getRepository(), this.client);
                        }
                        ins = null;
                        try {
                            response = this.client.getResourceVersions(this.props.getFullpath());
                            ins = response.getInputStream();
                        }
                        catch (WebDavException wde) {
                            if (wde.getErrorCode() != 401) {
                                throw wde;
                            }
                            boolean retry = PlatformUtils.getInstance().authenticateForServer(this.props.getRepository(), this.client);
                            if (!retry) break block17;
                            response = this.client.getResourceVersions(this.props.getFullpath());
                            ins = response.getInputStream();
                        }
                    }
                    if (ins != null) {
                        Properties verProps = new Properties();
                        verProps.load(ins);
                        entries = GuvnorMetadataUtils.parseHistoryProperties(verProps);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().writeLog(4, e.getMessage(), e);
                    if (response == null) break block18;
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        Activator.getDefault().writeLog(4, ioe.getMessage(), ioe);
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        Activator.getDefault().writeLog(4, ioe.getMessage(), ioe);
                    }
                }
            }
        }
        return entries;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedFile = null;
        this.props = null;
        action.setEnabled(false);
        try {
            IStructuredSelection sel;
            if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).getFirstElement() instanceof IFile && sel.size() == 1) {
                this.props = GuvnorMetadataUtils.getGuvnorMetadata((IResource)((IFile)sel.getFirstElement()));
                if (this.props != null) {
                    this.selectedFile = (IFile)sel.getFirstElement();
                    action.setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().writeLog(4, e.getMessage(), e);
        }
    }
}

