/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.example;

import java.util.ArrayList;
import org.drools.camel.example.Cheese;
import org.drools.camel.example.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class SpreadsheetIntegrationExampleTest {
    @Test
    public void testExecuteUsingKieAPI() throws Exception {
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.xls", this.getClass());
        KieSession ksession = this.getKieSession(dt);
        ksession.insert((Object)new Cheese("stilton", 42));
        ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Old man stilton", list.get(0));
    }

    private KieSession getKieSession(Resource dt) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write(dt);
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertTrue((boolean)kb.getResults().getMessages().isEmpty());
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        return ksession;
    }

    @Test
    public void testExecuteJBRULES3005() throws Exception {
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.xls", this.getClass());
        KieSession ksession = this.getKieSession(dt);
        ksession.insert((Object)new Cheese("stilton", 42));
        ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Old man stilton", list.get(0));
    }

    @Test
    public void testNamedWorksheet() throws Exception {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        dtconf.setWorksheetName("Tables");
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.xls", this.getClass()).setConfiguration((ResourceConfiguration)dtconf);
        KieSession ksession = this.getKieSession(dt);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 21));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Young man cheddar", list.get(0));
    }
}

