/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.example;

import java.lang.reflect.Field;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.junit4.CamelSpringJUnit4ClassRunner;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.definition.type.FactType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CamelSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/spring/test-mortgage-context.xml"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class GuvnorRulesMortgageTest {
    @EndpointInject(uri="mock:result")
    protected MockEndpoint resultEndpoint;
    @Produce(uri="direct:insert")
    protected ProducerTemplate produceFacts;
    @Produce(uri="direct:execute")
    protected ProducerTemplate produceExecute;
    @Resource(name="kbase1")
    protected KnowledgeBase kBase;
    @Resource(name="ksession1")
    protected StatefulKnowledgeSession ksession;

    @Test
    public void testDirect() throws Exception {
        FactType appType = this.kBase.getFactType("mortgages", "LoanApplication");
        Object application = appType.newInstance();
        appType.set(application, "amount", (Object)25000);
        appType.set(application, "deposit", (Object)1500);
        appType.set(application, "lengthYears", (Object)20);
        FactType incomeType = this.kBase.getFactType("mortgages", "IncomeSource");
        Object income = incomeType.newInstance();
        incomeType.set(income, "type", (Object)"Job");
        incomeType.set(income, "amount", (Object)65000);
        this.produceFacts.sendBody(application);
        ExecutionResultImpl result = (ExecutionResultImpl)this.produceExecute.requestBody(application, ExecutionResultImpl.class);
        Collection identifiers = result.getIdentifiers();
        Assert.assertNotNull((Object)identifiers);
        Assert.assertTrue((identifiers.size() >= 0 ? 1 : 0) != 0);
        for (String identifier : identifiers) {
            Object value = result.getValue(identifier);
            Assert.assertNotNull((Object)value);
            Class<?> clazz = value.getClass();
            Assert.assertEquals((Object)"mortgages.LoanApplication", (Object)clazz.getName());
            Field approved = value.getClass().getDeclaredField("approved");
            approved.setAccessible(true);
            Assert.assertEquals((Object)false, (Object)approved.get(value));
            Field approvedRate = value.getClass().getDeclaredField("approvedRate");
            approvedRate.setAccessible(true);
            Assert.assertEquals((Object)0, (Object)approvedRate.get(value));
        }
    }
}

