/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.kieci.withdomain;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.drools.testcoverage.domain.Customer;
import org.drools.testcoverage.domain.Drink;
import org.drools.testcoverage.domain.Order;
import org.drools.testcoverage.kieci.withdomain.util.KJarLoadUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class KJarLoadingTest {
    private static final KieServices KS = KieServices.Factory.get();
    private static final ReleaseId KJAR_RELEASE_ID = KJarLoadUtils.loadKJarGAV("testKJarGAV.properties", KJarLoadingTest.class);
    private KieSession kieSession;

    @Before
    public void init() {
        KieContainer container = KS.newKieContainer(KJAR_RELEASE_ID, this.getClass().getClassLoader());
        this.kieSession = container.newKieSession();
    }

    @After
    public void dispose() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
    }

    @Test
    public void testLoadingKJarWithDeps() {
        Assertions.assertThat((Object)this.kieSession).as("Failed to create KieSession.", new Object[0]).isNotNull();
        ((IterableAssert)Assertions.assertThat((Iterable)this.kieSession.getKieBase().getKiePackages()).as("No rules compiled.", new Object[0])).isNotEmpty();
    }

    @Test
    public void testRulesFireOldCustomerWithAlcohol() {
        Customer customer = new Customer("old customer", 18);
        Drink drink = new Drink("whisky", true);
        Order order = new Order(customer, drink);
        this.kieSession.insert((Object)order);
        this.kieSession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)order.isApproved()).as("Order should have been processed by the rules.", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)order.isApproved()).as("Order should have been approved.", new Object[0])).isTrue();
    }

    @Test
    public void testRulesFireYoungCustomerWithAlcohol() {
        Customer customer = new Customer("young customer", 15);
        Drink drink = new Drink("whisky", true);
        Order order = new Order(customer, drink);
        this.kieSession.insert((Object)order);
        this.kieSession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)order.isApproved()).as("Order should have been processed by the rules.", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)order.isApproved()).as("Order should have been disapproved.", new Object[0])).isFalse();
    }

    @Test
    public void testRulesFireOldCustomerWithNonAlcohol() {
        Customer customer = new Customer("old customer", 18);
        Drink drink = new Drink("water", false);
        Order order = new Order(customer, drink);
        this.kieSession.insert((Object)order);
        this.kieSession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)order.isApproved()).as("Order should have been processed by the rules.", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)order.isApproved()).as("Order should have been approved.", new Object[0])).isTrue();
    }

    @Test
    public void testRulesFireYoungCustomerWithNonAlcohol() {
        Customer customer = new Customer("young customer", 15);
        Drink drink = new Drink("water", false);
        Order order = new Order(customer, drink);
        this.kieSession.insert((Object)order);
        this.kieSession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)order.isApproved()).as("Order should have been processed by the rules.", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)order.isApproved()).as("Order should have been approved.", new Object[0])).isTrue();
    }
}

