/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.time.SessionPseudoClock;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.model.MessageEvent;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.internal.KnowledgeBaseFactory;

@RunWith(value=Parameterized.class)
public class FusionAfterBeforeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FusionAfterBeforeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAfterBeforeOperators() {
        Resource drlResource = KieServices.Factory.get().getResources().newClassPathResource("fusionAfterBeforeTest.drl", this.getClass());
        KieBase kieBase = KieBaseUtil.getKieBaseAndBuildInstallModule("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, drlResource);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        KieSession ksession = kieBase.newKieSession(ksconf, null);
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        EntryPoint stream = ksession.getEntryPoint("EventStream");
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        try {
            for (int i = 0; i < 3; ++i) {
                MessageEvent tc = new MessageEvent(MessageEvent.Type.received, new Message());
                stream.insert((Object)tc);
                ksession.fireAllRules();
                clock.advanceTime(8L, TimeUnit.SECONDS);
            }
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)listener.isRuleFired("AfterMessageEvent")).as("Rule 'AfterMessageEvent' was no fired!", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)listener.isRuleFired("BeforeMessageEvent")).as("Rule 'BeforeMessageEvent' was no fired!", new Object[0])).isTrue();
        int firedCount = 2;
        int actuallyFired = listener.ruleFiredCount("AfterMessageEvent");
        ((AbstractIntegerAssert)Assertions.assertThat((int)firedCount).as("Rule 'AfterMessageEvent' should be fired 2 times, but was fired " + firedCount + " time(s)!", new Object[0])).isEqualTo(actuallyFired);
        firedCount = listener.ruleFiredCount("BeforeMessageEvent");
        ((AbstractIntegerAssert)Assertions.assertThat((int)firedCount).as("Rule 'BeforeMessageEvent' should be fired 2 times, but was fired " + firedCount + " time(s)!", new Object[0])).isEqualTo(actuallyFired);
    }
}

