/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression.mvel;

import java.util.ArrayList;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.runtime.KieSession;

public class MvelLinkageErrorTest {
    private static final String TEST_FACT = "test";
    private static final String DRL = "package " + MvelLinkageErrorTest.class.getPackage().getName() + " \ndialect \"mvel\"\nimport " + MvelLinkageErrorTest.class.getPackage().getName() + ".* \nglobal java.util.List output \nrule rule1 \n  when \n    String(NotLoadableClass: length) \n  then \n    output.add(NotLoadableClass); \nend\n";
    private KieSession kieSession;

    @Before
    public void init() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", DRL);
        ks.newKieBuilder(kfs).buildAll();
        this.kieSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @After
    public void cleanup() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
    }

    @Test
    public void testMvelLinkageError() throws Exception {
        ArrayList result = new ArrayList();
        this.kieSession.setGlobal("output", result);
        this.kieSession.insert((Object)TEST_FACT);
        try {
            int fired = this.kieSession.fireAllRules();
            ((AbstractIntegerAssert)Assertions.assertThat((int)fired).as("Unexpected number of rules fired.", new Object[0])).isEqualTo(1);
            ((AbstractListAssert)Assertions.assertThat(result).as("Rule produced unexpected result value.", new Object[0])).containsExactly((Object[])new Integer[]{TEST_FACT.length()});
        }
        finally {
            this.kieSession.dispose();
        }
    }
}

