/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KieBaseUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieBaseUtil.class);

    public static KieBase getDefaultKieBaseFromKieBuilder(KieBuilder kbuilder) {
        return KieBaseUtil.getDefaultKieBaseFromKieModule(kbuilder.getKieModule());
    }

    public static KieBase getDefaultKieBaseFromKieModule(KieModule kmodule) {
        return KieBaseUtil.getDefaultKieBaseFromReleaseId(kmodule.getReleaseId());
    }

    public static KieBase getDefaultKieBaseFromReleaseId(ReleaseId id) {
        return KieBaseUtil.getKieBaseFromReleaseIdByName(id, null);
    }

    public static KieBase getKieBaseFromClasspathResources(Class classLoaderFromClass, boolean failIfBuildError, String ... resources) {
        KieBuilder kieBuilder = KieBaseUtil.getKieBuilderFromClasspathResources(classLoaderFromClass, failIfBuildError, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBuilder);
    }

    public static KieBase getKieBaseFromResources(boolean failIfBuildError, Resource ... resources) {
        KieBuilder kieBuilder = KieBaseUtil.getKieBuilderFromResources(failIfBuildError, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBuilder);
    }

    public static KieBase getKieBaseFromReleaseIdByName(ReleaseId id, String name) {
        KieContainer container = KieServices.Factory.get().newKieContainer(id);
        if (name == null) {
            return container.getKieBase();
        }
        return container.getKieBase(name);
    }

    public static KieBase getKieBaseAndBuildInstallModuleFromDrl(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String drl) {
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return KieBaseUtil.getKieBaseAndBuildInstallModule(moduleGroupId, kieBaseTestConfiguration, drlResource);
    }

    public static KieBase getKieBaseAndBuildInstallModule(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieModule kieModule = KieBaseUtil.buildAndInstallKieModuleIntoRepo(moduleGroupId, kieBaseTestConfiguration, resources);
        return KieBaseUtil.getDefaultKieBaseFromReleaseId(kieModule.getReleaseId());
    }

    public static KieFileSystem getKieFileSystemWithKieModule(KieModuleModel kieModuleModel, ReleaseId releaseId, Resource ... resources) {
        KieFileSystem fileSystem = KieServices.Factory.get().newKieFileSystem();
        fileSystem.generateAndWritePomXML(releaseId);
        for (Resource resource : resources) {
            fileSystem.write(resource);
        }
        fileSystem.writeKModuleXML(kieModuleModel.toXML());
        return fileSystem;
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(String groupId, KieBaseTestConfiguration kieBaseConfiguration, String drl) {
        ReleaseId releaseId = KieBaseUtil.generateReleaseId(groupId);
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return KieBaseUtil.buildAndInstallKieModuleIntoRepo(releaseId, kieBaseConfiguration, drlResource);
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(String groupId, KieBaseTestConfiguration kieBaseConfiguration, Resource ... resources) {
        ReleaseId releaseId = KieBaseUtil.generateReleaseId(groupId);
        return KieBaseUtil.buildAndInstallKieModuleIntoRepo(releaseId, kieBaseConfiguration, resources);
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(ReleaseId releaseId, KieBaseTestConfiguration kieBaseConfiguration, Resource ... resources) {
        KieServices kieServices = KieServices.Factory.get();
        KieModuleModel module = kieServices.newKieModuleModel();
        KieBaseModel base = kieBaseConfiguration.getKieBaseModel(module);
        KieFileSystem fileSystem = KieBaseUtil.getKieFileSystemWithKieModule(module, releaseId, resources);
        KieBuilder builder = KieBaseUtil.getKieBuilderFromKieFileSystem(fileSystem, true);
        KieModule kieModule = builder.getKieModule();
        kieServices.getRepository().addKieModule(kieModule);
        return kieModule;
    }

    public static KieBuilder getKieBuilderFromKieFileSystem(KieFileSystem fileSystem, boolean failIfBuildError) {
        return KieBaseUtil.getKieBuilderFromFileSystemWithResources(fileSystem, failIfBuildError, new Resource[0]);
    }

    public static KieBuilder getKieBuilderFromClasspathResources(Class classLoaderFromClass, boolean failIfBuildError, String ... resources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (String resource : resources) {
            result.add(KieServices.Factory.get().getResources().newClassPathResource(resource, classLoaderFromClass));
        }
        return KieBaseUtil.getKieBuilderFromResources(failIfBuildError, result.toArray(new Resource[0]));
    }

    public static KieBuilder getKieBuilderFromResources(boolean failIfBuildError, Resource ... resources) {
        return KieBaseUtil.getKieBuilderFromFileSystemWithResources(KieServices.Factory.get().newKieFileSystem(), failIfBuildError, resources);
    }

    public static ReleaseId generateReleaseId(String groupId) {
        KieServices kieServices = KieServices.Factory.get();
        return kieServices.newReleaseId(groupId, UUID.randomUUID().toString(), "1.0.0-SNAPSHOT");
    }

    private static KieBuilder getKieBuilderFromFileSystemWithResources(KieFileSystem kfs, boolean failIfBuildError, Resource ... resources) {
        for (Resource res : resources) {
            kfs.write(res);
        }
        KieBuilder kbuilder = KieServices.Factory.get().newKieBuilder(kfs);
        kbuilder.buildAll();
        List msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.INFO});
        if (msgs.size() > 0) {
            LOGGER.info("KieBuilder information: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.WARNING})).size() > 0) {
            LOGGER.warn("KieBuilder warnings: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).size() > 0) {
            LOGGER.error("KieBuilder errors: {}", (Object)msgs.toString());
        }
        if (failIfBuildError) {
            ((AbstractListAssert)Assertions.assertThat((List)msgs).as(msgs.toString(), new Object[0])).isEmpty();
        }
        return kbuilder;
    }

    private KieBaseUtil() {
    }
}

