/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class DeclarationWithOrTest {
    private static final String FACT = "working";
    private static final String DRL = "global java.util.List list\n\nrule R\nwhen\n s: String( s.toString() == \"x\" || s.toString() == \"y\" )\nthen\n list.add(\"working\");\nend";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindingWithOrInLHS() {
        Resource resource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(DRL));
        resource.setTargetPath("src/main/resources/rule.drl");
        KieBuilder kbuilder = KieBaseUtil.getKieBuilderFromResources(true, resource);
        KieContainer kcontainer = KieServices.Factory.get().newKieContainer(kbuilder.getKieModule().getReleaseId());
        KieSession ksession = kcontainer.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        try {
            ksession.insert((Object)"y");
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
        ((AbstractListAssert)Assertions.assertThat(list).as("Unexpected element in result global", new Object[0])).containsExactly((Object[])new String[]{FACT});
    }
}

