/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;

@RunWith(value=Parameterized.class)
public class SerializableGeneratedTypesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SerializableGeneratedTypesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testSerializability() throws Exception {
        Resource drlResource = KieServices.Factory.get().getResources().newClassPathResource("serializableGeneratedTypesTest.drl", this.getClass());
        KieBase kieBase = KieBaseUtil.getKieBaseAndBuildInstallModule("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, drlResource);
        KieSession session = kieBase.newKieSession();
        FactType testEventType = session.getKieBase().getFactType("org.drools.testcoverage.regression", "TestEvent");
        for (int i = 0; i < 10; ++i) {
            Object testEvent = testEventType.newInstance();
            testEventType.set(testEvent, "id", (Object)("id" + i));
            EntryPoint mainStream = session.getEntryPoint("test");
            mainStream.insert(testEvent);
            session.fireAllRules();
        }
    }
}

