/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KieUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieUtil.class);

    public static KieModule buildAndInstallKieModuleIntoRepo(String groupId, KieModuleModel kieModuleModel, Resource ... resources) {
        ReleaseId releaseId = KieUtil.generateReleaseId(groupId);
        return KieUtil.buildAndInstallKieModuleIntoRepo(releaseId, kieModuleModel, resources);
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(ReleaseId releaseId, KieModuleModel kieModuleModel, Resource ... resources) {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem fileSystem = KieUtil.getKieFileSystemWithKieModule(kieModuleModel, releaseId, resources);
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem(fileSystem, true);
        KieModule kieModule = builder.getKieModule();
        kieServices.getRepository().addKieModule(kieModule);
        return kieModule;
    }

    public static KieModuleModel createKieModuleModel() {
        KieServices kieServices = KieServices.Factory.get();
        return kieServices.newKieModuleModel();
    }

    public static KieFileSystem getKieFileSystemWithKieModule(KieModuleModel kieModuleModel, ReleaseId releaseId, Resource ... resources) {
        KieFileSystem fileSystem = KieServices.Factory.get().newKieFileSystem();
        fileSystem.generateAndWritePomXML(releaseId);
        for (Resource resource : resources) {
            fileSystem.write(resource);
        }
        fileSystem.writeKModuleXML(kieModuleModel.toXML());
        return fileSystem;
    }

    public static KieBuilder getKieBuilderFromKieFileSystem(KieFileSystem fileSystem, boolean failIfBuildError) {
        return KieUtil.getKieBuilderFromFileSystemWithResources(fileSystem, failIfBuildError, new Resource[0]);
    }

    public static KieBuilder getKieBuilderFromResources(boolean failIfBuildError, Resource ... resources) {
        return KieUtil.getKieBuilderFromFileSystemWithResources(KieServices.Factory.get().newKieFileSystem(), failIfBuildError, resources);
    }

    private static KieBuilder getKieBuilderFromFileSystemWithResources(KieFileSystem kfs, boolean failIfBuildError, Resource ... resources) {
        for (Resource res : resources) {
            kfs.write(res);
        }
        KieBuilder kbuilder = KieServices.Factory.get().newKieBuilder(kfs);
        kbuilder.buildAll();
        List msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.INFO});
        if (msgs.size() > 0) {
            LOGGER.info("KieBuilder information: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.WARNING})).size() > 0) {
            LOGGER.warn("KieBuilder warnings: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).size() > 0) {
            LOGGER.error("KieBuilder errors: {}", (Object)msgs.toString());
        }
        if (failIfBuildError) {
            Assertions.assertThat((List)msgs).as(msgs.toString(), new Object[0]).isEmpty();
        }
        return kbuilder;
    }

    public static ReleaseId generateReleaseId(String groupId) {
        KieServices kieServices = KieServices.Factory.get();
        return kieServices.newReleaseId(groupId, UUID.randomUUID().toString(), "1.0.0-SNAPSHOT");
    }

    public static KieBuilder getKieBuilderFromClasspathResources(Class classLoaderFromClass, boolean failIfBuildError, String ... resources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (String resource : resources) {
            result.add(KieServices.Factory.get().getResources().newClassPathResource(resource, classLoaderFromClass));
        }
        return KieUtil.getKieBuilderFromResources(failIfBuildError, result.toArray(new Resource[0]));
    }

    private KieUtil() {
    }
}

